@extends('admin.base.base')
@section('titulo', 'Status Envio ' . $Email->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <table id="ingressos" class="table mt-0 table-hover no-wrap dataTable no-footer" data-page-size="10" role="grid" aria-describedby="tickets_info">
                                    <thead>
                                        <tr role="row">
                                            <th class="sorting">Destinatário</th>
                                            <th class="sorting">Status</th>
                                            <th class="sorting">Visualização</th>
                                        </tr>
                                    </thead>
                                    <tbody id="result_ingressos">
                                        @foreach ($Email->Destinatarios->take(250) as $item)
                                            <tr role="row" class="odd">
                                                <td>
                                                    {{ $item->Destinatario->name }} {{ $item->Destinatario->sobrenome }}</td>
                                                <td>
                                                    <span class="badge badge-pill badge-{{ $item->status == '0' ? 'danger' : 'success' }}">{{ $item->status_envio == '0' ? 'Aguardando envio' : 'Enviado' }}</span>
                                                </td>
                                                <td>
                                                    <span class="badge badge-pill badge-{{ $item->status_envio == '0' ? 'danger' : 'success' }}">{{ $item->status == '0' ? 'Entregue' : 'Visualizado' }}</span>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('css')
    <style>

    </style>
@endsection
@section('js')
    <script src="{{ url('assets/vendor_components/datatable/datatables.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/jquery.peity/jquery.peity.js') }}"></script>
    <script src="{{ url('admin') }}/src/js/pages/data-table.js"></script>
    <script src="{{ url('admin') }}/src/js/pages/app-ticket.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        let totalEnviados = 0;

        $(document).ready(function() {
            enviarLote(); // Inicia o envio automático
        });

        function enviarLote() {
            mostrarLoaderSwal();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('send.email') }}",
                method: 'POST',
                data: {
                    id: {{ $Email->id }},
                    evento_id: {{ $Evento->id }},
                },
                success: function(result) {
                    if (result.continuar) {
                        totalEnviados += result.enviados;
                        atualizarLoader(result.restantes);
                        setTimeout(() => enviarLote(), 1500);
                    } else {
                        Swal.fire({
                            icon: "success",
                            title: "Envio concluído!",
                            text: "Todos os e-mails foram enviados com sucesso.",
                            timer: 4000,
                            showConfirmButton: false
                        });
                        setTimeout(() => location.reload(), 4000);
                    }
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        icon: "error",
                        title: "Erro no envio",
                        text: "Houve um problema ao enviar os e-mails. Tentando novamente...",
                        timer: 2500,
                        showConfirmButton: false
                    });
                    setTimeout(() => enviarLote(), 3000);
                }
            });
        }

        function mostrarLoaderSwal() {
            Swal.fire({
                title: "Enviando E-mails...",
                html: `<b>Iniciando envio</b>`,
                allowOutsideClick: false,
                allowEscapeKey: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
        }

        function atualizarLoader(restantes) {
            Swal.update({
                html: `<b>Restam ${restantes} destinatários...</b>`,
            });
        }
    </script>
@endsection
