@extends('admin.base.base')
@section('titulo', 'Clientes')
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <div class="row">
                    <div class="col-12">
                        <div class="box">
                            <div class="box-header with-border">
                                <h4 class="box-title">Clientes</h4>
                            </div>
                            <div class="box-body p-15">
                                <div class="row p-10">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label class="form-label">Filtrar por</label>
                                                <input id="cliente" type="text" class="form-control" placeholder="Nome, cpf, celular, email">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <button onclick="javascript:Filtrar()" type="button" class="btn btn-primary btn-sm" style="margin-top: 30px">
                                                <i class="ti-save-alt"></i> Filtrar
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="box-body">
                                    <div class="table-responsive-sm">
                                        <table class="table mb-0">
                                            <thead>
                                                <tr>
                                                    <th scope="col">ID</th>
                                                    <th scope="col">Nome</th>
                                                    <th scope="col">CPF</th>
                                                    <th scope="col">Celular</th>
                                                    <th scope="col">E-mail</th>
                                                    <th scope="col">Ações</th>
                                                </tr>
                                            </thead>
                                            <tr id="progress" class="d-none">
                                                <td colspan="6">
                                                    <div class="progress">
                                                        <div class="progress-bar progress-bar-success progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%">
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tbody id="result_socios">

                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ url('adm') }}/assets/vendor_components/datatable/datatables.min.js"></script>
    <script src="{{ url('adm') }}/src/js/pages/data-table.js"></script>

    <script>
        let loadingInterval = null;

        function Filtrar() {
            $("#result_socios").addClass('d-none');
            let $progress = $("#progress");
            let $progressBar = $progress.find('.progress-bar');

            // Garante que a barra reinicie do zero e que animações antigas sejam canceladas
            clearInterval(loadingInterval);
            $progress.removeClass('d-none');
            $progressBar.css('width', '0%').attr('aria-valuenow', 0);

            let percentage = 0;
            loadingInterval = setInterval(() => {
                percentage += Math.floor(Math.random() * 10) + 5; // 5~15% por incremento
                if (percentage >= 90) {
                    clearInterval(loadingInterval);
                } else {
                    $progressBar.css('width', percentage + '%').attr('aria-valuenow', percentage);
                }
            }, 200); // velocidade de crescimento do progresso

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('result.clientes') }}",
                method: 'POST',
                data: {
                    cliente: $("#cliente").val(),
                    evento: $("#evento").val(),
                },
                success: function(result) {
                    $("#result_socios").removeClass('d-none');
                    clearInterval(loadingInterval);
                    $progressBar.css('width', '100%').attr('aria-valuenow', 100);
                    setTimeout(() => {
                        $progress.addClass('d-none');
                        $progressBar.css('width', '0%').attr('aria-valuenow', 0);
                        $("#result_socios").html(result);
                    }, 300);


                },
                error: function() {
                    clearInterval(loadingInterval);
                    $progress.addClass('d-none');
                    $progressBar.css('width', '0%').attr('aria-valuenow', 0);
                    alert('Erro ao buscar Clientes');
                }
            });
        }
    </script>
@endsection
