<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" href="https://crm-admin-dashboard-template.multipurposethemes.com/images/favicon.ico">

    <title>{{ env('APP_NAME') }} - @yield('titulo')</title>

    <!-- Vendors Style-->
    <link rel="stylesheet" href="{{ url('admin') }}/src/css/vendors_css.css">

    <!-- Style-->
    <link rel="stylesheet" href="{{ url('admin') }}/src/css/style.css">
    <link rel="stylesheet" href="{{ url('admin') }}/src/css/skin_color.css">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@7.4.47/css/materialdesignicons.min.css" rel="stylesheet">
    <!-- CDN do Font Awesome 6 (gratuito) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
    <style>
        .nopadding {
            padding: 0 !important;
        }

        .progress-container {
            display: flex;
            align-items: center;
        }

        .soldticket-bar {
            margin-bottom: 0;
            max-height: 100%;
            max-width: 150px;
            height: 22px;
            position: relative;
            border-radius: 5px;
            margin: 0;
            width: 100%;
            display: flex;
            align-items: center;
            /* Alinha o conteúdo verticalmente */
            justify-content: space-between;
            /* Espaça os itens entre as extremidades */
        }

        .soldticket-bar>.progress-sold,
        .soldticket-bar>.progress-total {
            position: relative;
            /* Altere de absolute para relative */
            font-size: 12px;
            /* Ajuste o tamanho da fonte, se necessário */
            line-height: normal;
            /* Certifique-se de que o line-height esteja ajustado */
            margin: 0 5px;
            /* Margem para espaçamento interno */
        }


        .soldticket-bar>.progress-sold {
            position: absolute;
            left: 5px;
            top: 1px;
        }

        .soldticket-bar>.progress-total {
            position: absolute;
            right: 5px;
            top: 1px;
        }

        element {
            width: 54%;
        }

        .soldticket-bar .progress-bar {
            background-color: #6ad9d0;
        }

        .progress-bar {
            -webkit-box-shadow: none;
            box-shadow: none;
        }

        .progress-bar {
            float: left;
            width: 0%;
            height: 100%;
            font-size: 10px;
            line-height: 23px;
            color: #fff;
            text-align: center;
            background-color: #0097ff;
            -webkit-box-shadow: inset 0 -1px 0 rgba(0, 0, 0, .15);
            box-shadow: inset 0 -1px 0 rgba(0, 0, 0, .15);
            -webkit-transition: width .6s ease;
            -o-transition: width .6s ease;
            transition: width .6s ease;
        }

        * {
            outline: 0 !important;
        }

        .soldticket-bar+i {
            position: absolute;
            top: 1px;
            left: 150px;
            line-height: 20px;
        }

        .sweet-alert h2 {
            font-size: 20px !important;
            /* ajuste o valor conforme necessário */
        }
    </style>
</head>

<body class="hold-transition light-skin sidebar-mini theme-primary fixed">

    <div class="wrapper">
        <header class="main-header">
            <div class="d-flex align-items-center logo-box justify-content-start d-md-none d-block">
                <!-- Logo -->
                <a href="{{ route('dashboard') }}" class="logo">
                    <div class="logo-mini w-30">
                        <span class="dark-logo"><img src="images/logo-letter-white.png" alt="logo"></span>
                    </div>
                    <div class="logo-lg">
                        <span class="light-logo"><img src="images/logo-dark-text.png" alt="logo"></span>
                        <span class="dark-logo"><img src="images/logo-light-text.png" alt="logo"></span>
                    </div>
                </a>
            </div>
            <!-- Header Navbar -->
            <nav class="navbar navbar-static-top">
                <!-- Sidebar toggle button-->
                <div class="app-menu">
                    <ul class="header-megamenu nav">
                        <li class="btn-group nav-item">
                            <a href="#" class="waves-effect waves-light nav-link push-btn btn-primary-light" data-toggle="push-menu" role="button">
                                <i class="icon-Menu"><span class="path1"></span><span class="path2"></span></i>
                            </a>
                        </li>
                        <li class="btn-group d-lg-inline-flex d-none">
                            <div class="app-menu">
                                <div class="search-bx mx-5">
                                    <form>
                                        <div class="input-group">
                                            <input type="search" class="form-control" placeholder="Buscar Evento">
                                            <div class="input-group-append">
                                                <button class="btn" type="submit" id="button-addon3"><i class="icon-Search"><span class="path1"></span><span class="path2"></span></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>

                <div class="navbar-custom-menu r-side">
                    <ul class="nav navbar-nav">
                        <li class="dropdown notifications-menu btn-group nav-item">
                            <a href="#" class="waves-effect waves-light nav-link btn-primary-light svg-bt-icon" data-bs-toggle="dropdown" title="Notifications">
                                <i class="icon-Notifications"><span class="path1"></span><span class="path2"></span></i>
                                <div class="pulse-wave"></div>
                            </a>
                            <ul class="dropdown-menu animated bounceIn">
                                <li class="header">
                                    <div class="p-20">
                                        <div class="flexbox">
                                            <div>
                                                <h4 class="mb-0 mt-0">Notifications</h4>
                                            </div>
                                            <div>
                                                <a href="#" class="text-danger">Clear All</a>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li>
                                    <!-- inner menu: contains the actual data -->
                                    <ul class="menu sm-scrol">
                                        <li>
                                            <a href="#">
                                                <i class="fa fa-users text-info"></i> Curabitur id eros quis nunc suscipit blandit.
                                            </a>
                                        </li>
                                        <li>
                                            <a href="#">
                                                <i class="fa fa-warning text-warning"></i> Duis malesuada justo eu sapien elementum, in semper diam posuere.
                                            </a>
                                        </li>
                                        <li>
                                            <a href="#">
                                                <i class="fa fa-users text-danger"></i> Donec at nisi sit amet tortor commodo porttitor pretium a erat.
                                            </a>
                                        </li>
                                        <li>
                                            <a href="#">
                                                <i class="fa fa-shopping-cart text-success"></i> In gravida mauris et nisi
                                            </a>
                                        </li>
                                        <li>
                                            <a href="#">
                                                <i class="fa fa-user text-danger"></i> Praesent eu lacus in libero dictum fermentum.
                                            </a>
                                        </li>
                                        <li>
                                            <a href="#">
                                                <i class="fa fa-user text-primary"></i> Nunc fringilla lorem
                                            </a>
                                        </li>
                                        <li>
                                            <a href="#">
                                                <i class="fa fa-user text-success"></i> Nullam euismod dolor ut quam interdum, at scelerisque ipsum imperdiet.
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                                <li class="footer">
                                    <a href="#">View all</a>
                                </li>
                            </ul>
                        </li>
                        <li class="btn-group nav-item">
                            <a href="#" class="waves-effect waves-light nav-link btn-primary-light svg-bt-icon" title="" data-bs-toggle="modal" data-bs-target="#quick_actions_toggle">
                                <i class="icon-Layout-arrange"><span class="path1"></span><span class="path2"></span></i>
                            </a>
                        </li>
                        <li class="btn-group nav-item d-xl-inline-flex d-none">
                            <a href="#" class="waves-effect waves-light nav-link btn-primary-light svg-bt-icon" title="" data-bs-toggle="modal" data-bs-target="#quick_panel_toggle">
                                <i class="icon-Notification"><span class="path1"></span><span class="path2"></span></i>
                            </a>
                        </li>
                        <li class="btn-group nav-item d-xl-inline-flex d-none">
                            <a href="#" class="waves-effect waves-light nav-link btn-primary-light svg-bt-icon" title="" data-bs-toggle="modal" data-bs-target="#quick_shop_toggle">
                                <i class="icon-Cart1"><span class="path1"></span><span class="path2"></span></i>
                            </a>
                        </li>
                        <li class="btn-group nav-item d-xl-inline-flex d-none">
                            <a href="#" class="waves-effect waves-light nav-link btn-primary-light svg-bt-icon" title="" id="live-chat">
                                <i class="icon-Chat"><span class="path1"></span><span class="path2"></span></i>
                            </a>
                        </li>

                        <li class="btn-group">
                            <a href="#" class="waves-effect waves-light nav-link btn-primary-light svg-bt-icon dropdown-toggle" data-bs-toggle="dropdown">
                                <img class="rounded" src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/usa.svg" alt="">
                            </a>
                            <div class="dropdown-menu">
                                <a class="dropdown-item my-5" href="#"><img class="w-20 rounded me-10" src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/usa.svg" alt=""> English</a>
                                <a class="dropdown-item my-5" href="#"><img class="w-20 rounded me-10" src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/spain.svg" alt=""> Spanish</a>
                                <a class="dropdown-item my-5" href="#"><img class="w-20 rounded me-10" src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/ger.svg" alt=""> German</a>
                                <a class="dropdown-item my-5" href="#"><img class="w-20 rounded me-10" src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/jap.svg" alt=""> Japanese</a>
                                <a class="dropdown-item my-5" href="#"><img class="w-20 rounded me-10" src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/fra.svg" alt=""> French</a>
                            </div>
                        </li>

                        <li class="btn-group nav-item d-xl-inline-flex d-none">
                            <a href="#" data-provide="fullscreen" class="waves-effect waves-light nav-link btn-primary-light svg-bt-icon" title="Full Screen">
                                <i class="icon-Expand-arrows"><span class="path1"></span><span class="path2"></span></i>
                            </a>
                        </li>

                        <!-- User Account-->
                        <li class="dropdown user user-menu">
                            <a href="#" class="waves-effect waves-light dropdown-toggle w-auto l-h-12 bg-transparent p-0 no-shadow" title="User" data-bs-toggle="modal" data-bs-target="#quick_user_toggle">
                                <div class="d-flex pt-1">
                                    <div class="text-end me-10">
                                        <p class="pt-5 fs-14 mb-0 fw-700 text-primary">Johen Doe</p>
                                        <small class="fs-10 mb-0 text-uppercase text-mute">Admin</small>
                                    </div>
                                    <img src="{{ url('admin') }}/images/avatar/avatar-1.png" class="avatar rounded-10 bg-primary-light h-40 w-40" alt="" />
                                </div>
                            </a>
                        </li>

                    </ul>
                </div>
            </nav>
        </header>

        <aside class="main-sidebar">
            <!-- sidebar-->
            <section class="sidebar position-relative">
                <div class="d-flex align-items-center logo-box justify-content-start d-md-block d-none">
                    <!-- Logo -->
                    <a href="index.html" class="logo">
                        <!-- logo-->
                        <div class="logo-mini">
                            <span class="light-logo"><img src="{{ url('images/logo-letter.png') }}" alt="logo"></span>
                        </div>
                        <div class="logo-lg">
                            <span class="light-logo fs-36 fw-700"><img src="{{ url('images/musa.png') }}" alt="logo" width="75%"></span>
                        </div>
                    </a>
                </div>
                <div class="user-profile my-15 px-20 py-10 b-1 rounded10 mx-15">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="image d-flex align-items-center">
                            <img src="{{ url('images/user.png') }}" class="rounded-0 me-10" alt="User Image">
                            <div>
                                <h4 class="mb-0 fw-600">{{ Auth::user()->name }}</h4>
                                <p class="mb-0">{{ Auth::user()->cargo }}</p>
                            </div>
                        </div>
                        <div class="info">
                            <a class="dropdown-toggle p-15 d-grid" data-bs-toggle="dropdown" href="#"></a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <a class="dropdown-item" href="extra_profile.html"><i class="ti-user"></i> Perfil</a>
                                <a class="dropdown-item" href="mailbox.html"><i class="ti-email"></i> Mensagens</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" onclick="javascript:Sair()"><i class="ti-lock"></i> Sair</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="multinav">
                    <div class="multinav-scroll" style="height: 97%;">
                        @if (Auth::user()->nivel == '1')
                            <div style="margin: 10px;">
                                <a href="{{ route('evento.create') }}" class="btn btn-primary w-p100 mb-30 text-white">Abrir Vendas</a>
                            </div>
                        @endif
                        <ul class="sidebar-menu" data-widget="tree">
                            <li class="header">Menu</li>
                            <li>
                                <a href="{{ route('dashboard') }}">
                                    <i class="icon-Layout-4-blocks"><span class="path1"></span><span class="path2"></span></i>
                                    <span>Dashboard</span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('financeiro.relatorios') }}">
                                    <i class="icon-Flag"><span class="path1"></span><span class="path2"></span></i>
                                    <span>Relatórios</span>
                                </a>
                            </li>
                            @if (Auth::user()->nivel == '1')
                                <li>
                                    <a href="{{ route('clientes.index') }}">
                                        <i class="icon-Chart-pie"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Monitoramento</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('clientes.index') }}">
                                        <i class="icon-Chart-pie"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Clientes</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('novos.pedidos') }}">
                                        <i class="icon-Flag"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Novos Pedidos</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('financeiro.pagamentos') }}">
                                        <i class="icon-Flag"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Pagamentos</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('relatorio.mensal') }}">
                                        <i class="icon-Flag"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Relatório Mensal</span>
                                    </a>
                                </li>
                            @endif

                            {{-- @if (!empty($Evento))
                                <li class="header">Evento</li>
                                <li class="treeview {{ in_array(Route::currentRouteName(), ['evento.index', 'evento.integracoes']) ? 'menu-open' : '' }}">
                                    <a href="#">
                                        <i class="icon-Chart-bar1"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Painel do Evento</span>
                                        <span class="pull-right-container">
                                            <i class="fa fa-angle-right pull-right"></i>
                                        </span>
                                    </a>
                                    <ul class="treeview-menu" style="{{ in_array(Route::currentRouteName(), ['evento.index', 'evento.integracoes']) ? 'display: block;' : 'display: none;' }}">
                                        <li>
                                            <a href="{{ route('evento.index', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.index' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Visão Geral
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('evento.integracoes', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.integracoes' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Integrações
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                                <li class="treeview {{ in_array(Route::currentRouteName(), ['evento.editar']) ? 'menu-open' : '' }}">
                                    <a href="#">
                                        <i class="icon-Clock"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Evento</span>
                                        <span class="pull-right-container">
                                            <i class="fa fa-angle-right pull-right"></i>
                                        </span>
                                    </a>
                                    <ul class="treeview-menu" style="{{ in_array(Route::currentRouteName(), ['evento.editar']) ? 'display: block;' : 'display: none;' }}">
                                        <li>
                                            <a href="{{ route('evento.editar', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.show' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Editar Evento
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('evento.colaboradores', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.colaboradores' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Colaboradores
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('evento.pdvs', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.pdvs' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>PDV's
                                            </a>
                                        </li>
                                    </ul>
                                </li>

                                <li class="treeview {{ in_array(Route::currentRouteName(), ['ingressos.dashboard', 'mensagem.ingressos']) ? 'menu-open' : '' }}">
                                    <a href="#">
                                        <i class="icon-Ticket"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Ingressos</span>
                                        <span class="pull-right-container">
                                            <i class="fa fa-angle-right pull-right"></i>
                                        </span>
                                    </a>
                                    <ul class="treeview-menu" style="{{ in_array(Route::currentRouteName(), ['ingressos.dashboard', 'mensagem.ingressos', 'evento.cupons']) ? 'display: block;' : 'display: none;' }}">
                                        <li>
                                            <a href="{{ route('ingressos.dashboard', $Evento) }}" class="{{ Route::currentRouteName() == 'ingressos.dashboard' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Visão Geral
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('evento.cupons', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.cupons' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Cupoms de desconto
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('mensagem.ingressos', $Evento) }}" class="{{ Route::currentRouteName() == 'mensagem.ingressos' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Mensagem do Ingresso
                                            </a>
                                        </li>
                                    </ul>
                                </li>

                                <li class="treeview {{ in_array(Route::currentRouteName(), ['evento.participantes', 'evento.pdv']) ? 'menu-open' : '' }}">
                                    <a href="#">
                                        <i class="icon-User"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Participantes</span>
                                        <span class="pull-right-container">
                                            <i class="fa fa-angle-right pull-right"></i>
                                        </span>
                                    </a>
                                    <ul class="treeview-menu" style="{{ in_array(Route::currentRouteName(), ['evento.participantes', 'evento.pdv']) ? 'display: block;' : 'display: none;' }}">
                                        <li>
                                            <a href="{{ route('evento.participantes', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.participantes' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Listar Participantes
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('evento.pdv', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.pdv' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Adicionar Participantes
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                                <li class="treeview {{ in_array(Route::currentRouteName(), ['evento.checkin', 'evento.checkin.online']) ? 'menu-open' : '' }}">
                                    <a href="#">
                                        <i class="icon-Barcode"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Check-In</span>
                                        <span class="pull-right-container">
                                            <i class="fa fa-angle-right pull-right"></i>
                                        </span>
                                    </a>
                                    <ul class="treeview-menu" style="{{ in_array(Route::currentRouteName(), ['evento.checkin', 'evento.checkin.online']) ? 'display: block;' : 'display: none;' }}">
                                        <li>
                                            <a href="{{ route('evento.checkin', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.checkin' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Visão Geral
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('evento.checkin.online', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.checkin.online' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Check-In Online
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                                <li class="treeview {{ in_array(Route::currentRouteName(), ['financeiro.index', 'historico.transacoes']) ? 'menu-open' : '' }}">
                                    <a href="#">
                                        <i class="icon-Money"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Financeiro</span>
                                        <span class="pull-right-container">
                                            <i class="fa fa-angle-right pull-right"></i>
                                        </span>
                                    </a>
                                    <ul class="treeview-menu" style="{{ in_array(Route::currentRouteName(), ['financeiro.index', 'historico.transacoes']) ? 'display: block;' : 'display: none;' }}">
                                        <li>
                                            <a href="{{ route('financeiro.index', $Evento) }}" class="{{ Route::currentRouteName() == 'financeiro.index' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Visão Geral
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('historico.transacoes', $Evento) }}" class="{{ Route::currentRouteName() == 'historico.transacoes' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Histórico de Transações
                                            </a>
                                        </li>

                                    </ul>
                                </li>
                                <li class="treeview {{ in_array(Route::currentRouteName(), ['evento.relatorio']) ? 'menu-open' : '' }}">
                                    <a href="#">
                                        <i class="icon-Chart-line"><span class="path1"></span><span class="path2"></span></i>
                                        <span>Relatórios</span>
                                        <span class="pull-right-container">
                                            <i class="fa fa-angle-right pull-right"></i>
                                        </span>
                                    </a>
                                    <ul class="treeview-menu" style="{{ in_array(Route::currentRouteName(), ['evento.relatorio.tipo.ingresso', 'evento.relatorio.relatorio.por.pacote']) ? 'display: block;' : 'display: none;' }}">
                                        <li>
                                            <a href="{{ route('evento.relatorio.tipo.ingresso', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.relatorio.tipo.ingresso' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Vendas
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('evento.relatorio.relatorio.por.pacote', $Evento) }}" class="{{ Route::currentRouteName() == 'evento.relatorio.relatorio.por.pacoteo' ? 'active' : '' }}">
                                                <i class="icon-Commit"><span class="path1"></span><span class="path2"></span></i>Ingresso
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                            @endif --}}
                            <li>
                                <a href="javascript:void(0)" onclick="javascript:Sair()">
                                    <i class="icon-Flag"><span class="path1"></span><span class="path2"></span></i>
                                    <span>Sair</span>
                                </a>
                            </li>
                        </ul>

                        {{-- <a href="https://lopakdesigner.com">
                                        <img src="https://lopakdesigner.com/uploads/logo.png" class="sideimg p-5" alt="">
                                    </a> --}}

                        <div class="sidebar-widgets">
                            <div class="mx-25 mb-30 side-bx bg-primary-light rounded10" style="padding: 20px;">
                                <div class="text-center">
                                    <img src="https://lopakdesigner.com/uploads/logo.png" width="60%">
                                </div>
                            </div>
                            <div class="copyright text-center m-25">
                                <p>
                                    <strong class="d-block">{{ env('APP_COPY') }}</strong> ©
                                    <script>
                                        document.write(new Date().getFullYear())
                                    </script> Todos os direitos reservados
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </aside>

        @yield('content')

        <footer class="main-footer">

            &copy;
            <script>
                document.write(new Date().getFullYear())
            </script> <a href="https://www.lopakdesigner.com/">{{ env('APP_COPY') }}</a>. Todos os direitos reservados.
        </footer>
        <!-- Side panel -->
        <!-- quick_actions_toggle -->
        <div class="modal modal-right fade" id="quick_actions_toggle" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content slim-scroll">
                    <div class="modal-body bg-white p-30">
                        <div class="d-flex align-items-center justify-content-between pb-30">
                            <h4 class="m-0">Quick Actions<br>
                                <small class="badge fs-12 badge-primary mt-10">23 tasks pending</small>
                            </h4>
                            <a href="#" class="btn btn-icon btn-danger-light btn-sm no-shadow" data-bs-dismiss="modal">
                                <span class="fa fa-close"></span>
                            </a>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <a class="waves-effect waves-light btn btn-app btn btn-primary-light btn-flat mx-0 mb-20 no-shadow py-35 h-auto d-block" href="accounting.html">
                                    <i class="icon-Euro fs-36"><span class="path1"></span><span class="path2"></span></i>
                                    <span class="fs-16">Accounting</span>
                                </a>
                            </div>
                            <div class="col-6">
                                <a class="waves-effect waves-light btn btn-app btn btn-primary-light btn-flat mx-0 mb-20 no-shadow py-35 h-auto d-block" href="contact_userlist_grid.html">
                                    <i class="icon-Mail-attachment fs-36"><span class="path1"></span><span class="path2"></span></i>
                                    <span class="fs-16">Members</span>
                                </a>
                            </div>
                            <div class="col-6">
                                <a class="waves-effect waves-light btn btn-app btn btn-primary-light btn-flat mx-0 mb-20 no-shadow py-35 h-auto d-block" href="projects.html">
                                    <i class="icon-Box2 fs-36"><span class="path1"></span><span class="path2"></span></i>
                                    <span class="fs-16">Projects</span>
                                </a>
                            </div>
                            <div class="col-6">
                                <a class="waves-effect waves-light btn btn-app btn btn-primary-light btn-flat mx-0 mb-20 no-shadow py-35 h-auto d-block" href="contact_userlist.html">
                                    <i class="icon-Group fs-36"><span class="path1"></span><span class="path2"></span></i>
                                    <span class="fs-16">Customers</span>
                                </a>
                            </div>
                            <div class="col-6">
                                <a class="waves-effect waves-light btn btn-app btn btn-primary-light btn-flat mx-0 mb-20 no-shadow py-35 h-auto d-block" href="mailbox.html">
                                    <i class="icon-Chart-bar fs-36"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></i>
                                    <span class="fs-16">Email</span>
                                </a>
                            </div>
                            <div class="col-6">
                                <a class="waves-effect waves-light btn btn-app btn btn-primary-light btn-flat mx-0 mb-20 no-shadow py-35 h-auto d-block" href="setting.html">
                                    <i class="icon-Color-profile fs-36"><span class="path1"></span><span class="path2"></span></i>
                                    <span class="fs-16">Settings</span>
                                </a>
                            </div>
                            <div class="col-6">
                                <a class="waves-effect waves-light btn btn-app btn btn-primary-light btn-flat mx-0 mb-20 no-shadow py-35 h-auto d-block" href="ecommerce_orders.html">
                                    <i class="icon-Euro fs-36"><span class="path1"></span><span class="path2"></span></i>
                                    <span class="fs-18">Orders</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /quick_actions_toggle -->

        <!-- quick_panel_toggle -->
        <div class="modal modal-right fade" id="quick_panel_toggle" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content slim-scroll2">
                    <div class="modal-body bg-white py-20 px-0">
                        <div class="d-flex align-items-center justify-content-between pb-30">
                            <ul class="nav nav-tabs customtab3 px-30" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#quick_panel_logs">Audit Logs</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-bs-toggle="tab" href="#quick_panel_notifications">Notifications</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-bs-toggle="tab" href="#quick_panel_settings">Settings</a>
                                </li>
                            </ul>
                            <div class="offcanvas-close">
                                <a href="#" class="btn btn-icon btn-danger-light btn-sm no-shadow" data-bs-dismiss="modal">
                                    <span class="fa fa-close"></span>
                                </a>
                            </div>
                        </div>
                        <div class="px-30">
                            <div class="tab-content">
                                <div class="tab-pane active" id="quick_panel_logs" role="tabpanel">
                                    <div class="mb-30">
                                        <h5 class="fw-500 mb-15">System Messages</h5>
                                        <div class="d-flex align-items-center mb-30">
                                            <div class="me-15 bg-lightest h-50 w-50 l-h-50 rounded text-center">
                                                <img src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/color-svg/001-glass.svg" class="h-30" alt="">
                                            </div>
                                            <div class="d-flex flex-column flex-grow-1 me-2 fw-500">
                                                <a href="#" class="text-dark hover-primary mb-1 fs-16">Duis faucibus lorem</a>
                                                <span class="text-fade">Pharetra, Nulla</span>
                                            </div>
                                            <span class="badge badge-xl badge-light"><span class="fw-600">+125$</span></span>
                                        </div>
                                        <div class="d-flex align-items-center mb-30">
                                            <div class="me-15 bg-lightest h-50 w-50 l-h-50 rounded text-center">
                                                <img src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/color-svg/002-google.svg" class="h-30" alt="">
                                            </div>
                                            <div class="d-flex flex-column flex-grow-1 me-2 fw-500">
                                                <a href="#" class="text-dark hover-danger mb-1 fs-16">Mauris varius augue</a>
                                                <span class="text-fade">Pharetra, Nulla</span>
                                            </div>
                                            <span class="badge badge-xl badge-light"><span class="fw-600">+125$</span></span>
                                        </div>
                                        <div class="d-flex align-items-center mb-30">
                                            <div class="me-15 bg-lightest h-50 w-50 l-h-50 rounded text-center">
                                                <img src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/color-svg/003-settings.svg" class="h-30" alt="">
                                            </div>
                                            <div class="d-flex flex-column flex-grow-1 me-2 fw-500">
                                                <a href="#" class="text-dark hover-success mb-1 fs-16">Aliquam in magna</a>
                                                <span class="text-fade">Pharetra, Nulla</span>
                                            </div>
                                            <span class="badge badge-xl badge-light"><span class="fw-600">+125$</span></span>
                                        </div>
                                        <div class="d-flex align-items-center mb-30">
                                            <div class="me-15 bg-lightest h-50 w-50 l-h-50 rounded text-center">
                                                <img src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/color-svg/004-dad.svg" class="h-30" alt="">
                                            </div>
                                            <div class="d-flex flex-column flex-grow-1 me-2 fw-500">
                                                <a href="#" class="text-dark hover-info mb-1 fs-16">Phasellus venenatis nisi</a>
                                                <span class="text-fade">Pharetra, Nulla</span>
                                            </div>
                                            <span class="badge badge-xl badge-light"><span class="fw-600">+125$</span></span>
                                        </div>
                                        <div class="d-flex align-items-center">
                                            <div class="me-15 bg-lightest h-50 w-50 l-h-50 rounded text-center">
                                                <img src="https://crm-admin-dashboard-template.multipurposethemes.com/images/svg-icon/color-svg/005-paint-palette.svg" class="h-30" alt="">
                                            </div>
                                            <div class="d-flex flex-column flex-grow-1 me-2 fw-500">
                                                <a href="#" class="text-dark hover-warning mb-1 fs-16">Vivamus consectetur</a>
                                                <span class="text-fade">Pharetra, Nulla</span>
                                            </div>
                                            <span class="badge badge-xl badge-light"><span class="fw-600">+125$</span></span>
                                        </div>
                                    </div>
                                    <div class="mb-30">
                                        <h5 class="fw-500 mb-15">Tasks Overview</h5>
                                        <div class="d-flex align-items-center mb-30">
                                            <div class="me-15 bg-primary-light h-50 w-50 l-h-60 rounded text-center">
                                                <span class="icon-Library fs-24"><span class="path1"></span><span class="path2"></span></span>
                                            </div>
                                            <div class="d-flex flex-column fw-500">
                                                <a href="#" class="text-dark hover-primary mb-1 fs-16">Project Briefing</a>
                                                <span class="text-fade">Project Manager</span>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center mb-30">
                                            <div class="me-15 bg-danger-light h-50 w-50 l-h-60 rounded text-center">
                                                <span class="icon-Write fs-24"><span class="path1"></span><span class="path2"></span></span>
                                            </div>
                                            <div class="d-flex flex-column fw-500">
                                                <a href="#" class="text-dark hover-danger mb-1 fs-16">Concept Design</a>
                                                <span class="text-fade">Art Director</span>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center mb-30">
                                            <div class="me-15 bg-success-light h-50 w-50 l-h-60 rounded text-center">
                                                <span class="icon-Group-chat fs-24"><span class="path1"></span><span class="path2"></span></span>
                                            </div>
                                            <div class="d-flex flex-column fw-500">
                                                <a href="#" class="text-dark hover-success mb-1 fs-16">Functional Logics</a>
                                                <span class="text-fade">Lead Developer</span>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center mb-30">
                                            <div class="me-15 bg-info-light h-50 w-50 l-h-60 rounded text-center">
                                                <span class="icon-Attachment1 fs-24"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></span>
                                            </div>
                                            <div class="d-flex flex-column fw-500">
                                                <a href="#" class="text-dark hover-info mb-1 fs-16">Development</a>
                                                <span class="text-fade">DevOps</span>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center">
                                            <div class="me-15 bg-warning-light h-50 w-50 l-h-60 rounded text-center">
                                                <span class="icon-Shield-user fs-24"></span>
                                            </div>
                                            <div class="d-flex flex-column fw-500">
                                                <a href="#" class="text-dark hover-warning mb-1 fs-16">Testing</a>
                                                <span class="text-fade">QA Managers</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="quick_panel_notifications" role="tabpanel">
                                    <div>
                                        <div class="media-list">
                                            <a class="media media-single px-0" href="#">
                                                <h4 class="w-50 text-gray fw-500">10:10</h4>
                                                <div class="media-body ps-15 bs-5 rounded border-primary">
                                                    <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                                    <span class="text-fade">by Johne</span>
                                                </div>
                                            </a>

                                            <a class="media media-single px-0" href="#">
                                                <h4 class="w-50 text-gray fw-500">08:40</h4>
                                                <div class="media-body ps-15 bs-5 rounded border-success">
                                                    <p>Proin iaculis eros non odio ornare efficitur.</p>
                                                    <span class="text-fade">by Amla</span>
                                                </div>
                                            </a>

                                            <a class="media media-single px-0" href="#">
                                                <h4 class="w-50 text-gray fw-500">07:10</h4>
                                                <div class="media-body ps-15 bs-5 rounded border-info">
                                                    <p>In mattis mi ut posuere consectetur.</p>
                                                    <span class="text-fade">by Josef</span>
                                                </div>
                                            </a>

                                            <a class="media media-single px-0" href="#">
                                                <h4 class="w-50 text-gray fw-500">01:15</h4>
                                                <div class="media-body ps-15 bs-5 rounded border-danger">
                                                    <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                                    <span class="text-fade">by Rima</span>
                                                </div>
                                            </a>

                                            <a class="media media-single px-0" href="#">
                                                <h4 class="w-50 text-gray fw-500">23:12</h4>
                                                <div class="media-body ps-15 bs-5 rounded border-warning">
                                                    <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                                    <span class="text-fade">by Alaxa</span>
                                                </div>
                                            </a>
                                            <a class="media media-single px-0" href="#">
                                                <h4 class="w-50 text-gray fw-500">10:10</h4>
                                                <div class="media-body ps-15 bs-5 rounded border-primary">
                                                    <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                                    <span class="text-fade">by Johne</span>
                                                </div>
                                            </a>

                                            <a class="media media-single px-0" href="#">
                                                <h4 class="w-50 text-gray fw-500">08:40</h4>
                                                <div class="media-body ps-15 bs-5 rounded border-success">
                                                    <p>Proin iaculis eros non odio ornare efficitur.</p>
                                                    <span class="text-fade">by Amla</span>
                                                </div>
                                            </a>

                                            <a class="media media-single px-0" href="#">
                                                <h4 class="w-50 text-gray fw-500">07:10</h4>
                                                <div class="media-body ps-15 bs-5 rounded border-info">
                                                    <p>In mattis mi ut posuere consectetur.</p>
                                                    <span class="text-fade">by Josef</span>
                                                </div>
                                            </a>

                                            <a class="media media-single px-0" href="#">
                                                <h4 class="w-50 text-gray fw-500">01:15</h4>
                                                <div class="media-body ps-15 bs-5 rounded border-danger">
                                                    <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                                    <span class="text-fade">by Rima</span>
                                                </div>
                                            </a>

                                            <a class="media media-single px-0" href="#">
                                                <h4 class="w-50 text-gray fw-500">23:12</h4>
                                                <div class="media-body ps-15 bs-5 rounded border-warning">
                                                    <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                                    <span class="text-fade">by Alaxa</span>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="quick_panel_settings" role="tabpanel">
                                    <div>
                                        <form class="form">
                                            <!--begin::Section-->
                                            <div>
                                                <h5 class="fw-500 mb-15">Customer Care</h5>
                                                <div class="form-group mb-0 row align-items-center">
                                                    <label class="col-8 col-form-label">Enable Notifications:</label>
                                                    <div class="col-4 d-flex justify-content-end">
                                                        <button type="button" class="btn btn-sm btn-toggle btn-primary active" data-bs-toggle="button">
                                                            <span class="handle"></span>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="form-group mb-0 row align-items-center">
                                                    <label class="col-8 col-form-label">Enable Case Tracking:</label>
                                                    <div class="col-4 d-flex justify-content-end">
                                                        <button type="button" class="btn btn-sm btn-toggle btn-primary" data-bs-toggle="button">
                                                            <span class="handle"></span>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="form-group mb-0 row align-items-center">
                                                    <label class="col-8 col-form-label">Support Portal:</label>
                                                    <div class="col-4 d-flex justify-content-end">
                                                        <button type="button" class="btn btn-sm btn-toggle btn-primary active" data-bs-toggle="button">
                                                            <span class="handle"></span>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--end::Section-->
                                            <div class="dropdown-divider"></div>
                                            <!--begin::Section-->
                                            <div class="pt-2">
                                                <h5 class="fw-500 mb-15">Reports</h5>
                                                <div class="form-group mb-0 row align-items-center">
                                                    <label class="col-8 col-form-label">Generate Reports:</label>
                                                    <div class="col-4 d-flex justify-content-end">
                                                        <button type="button" class="btn btn-sm btn-toggle btn-danger active" data-bs-toggle="button">
                                                            <span class="handle"></span>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="form-group mb-0 row align-items-center">
                                                    <label class="col-8 col-form-label">Enable Report Export:</label>
                                                    <div class="col-4 d-flex justify-content-end">
                                                        <button type="button" class="btn btn-sm btn-toggle btn-danger active" data-bs-toggle="button">
                                                            <span class="handle"></span>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="form-group mb-0 row align-items-center">
                                                    <label class="col-8 col-form-label">Allow Data Collection:</label>
                                                    <div class="col-4 d-flex justify-content-end">
                                                        <button type="button" class="btn btn-sm btn-toggle btn-danger active" data-bs-toggle="button">
                                                            <span class="handle"></span>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--end::Section-->
                                            <div class="dropdown-divider"></div>
                                            <!--begin::Section-->
                                            <div class="pt-2">
                                                <h5 class="fw-500 mb-15">Memebers</h5>
                                                <div class="form-group mb-0 row align-items-center">
                                                    <label class="col-8 col-form-label">Enable Member singup:</label>
                                                    <div class="col-4 d-flex justify-content-end">
                                                        <button type="button" class="btn btn-sm btn-toggle btn-warning active" data-bs-toggle="button">
                                                            <span class="handle"></span>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="form-group mb-0 row align-items-center">
                                                    <label class="col-8 col-form-label">Allow User Feedbacks:</label>
                                                    <div class="col-4 d-flex justify-content-end">
                                                        <button type="button" class="btn btn-sm btn-toggle btn-warning active" data-bs-toggle="button">
                                                            <span class="handle"></span>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="form-group mb-0 row align-items-center">
                                                    <label class="col-8 col-form-label">Enable Customer Portal:</label>
                                                    <div class="col-4 d-flex justify-content-end">
                                                        <button type="button" class="btn btn-sm btn-toggle btn-warning active" data-bs-toggle="button">
                                                            <span class="handle"></span>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--end::Section-->
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /quick_panel_toggle -->

        <!-- quick_user_toggle -->
        <div class="modal modal-right fade" id="quick_user_toggle" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content slim-scroll3">
                    <div class="modal-body p-30 bg-white">
                        <div class="d-flex align-items-center justify-content-between pb-30">
                            <h4 class="m-0">User Profile
                                <small class="text-fade fs-12 ms-5">12 messages</small>
                            </h4>
                            <a href="#" class="btn btn-icon btn-danger-light btn-sm no-shadow" data-bs-dismiss="modal">
                                <span class="fa fa-close"></span>
                            </a>
                        </div>
                        <div>
                            <div class="d-flex flex-row">
                                <div class=""><img src="{{ url('admin') }}/images/avatar/avatar-2.png" alt="user" class="rounded bg-danger-light w-150" width="100"></div>
                                <div class="ps-20">
                                    <h5 class="mb-0">Johen Doe</h5>
                                    <p class="my-5 text-fade">Web Designer</p>
                                    <a href="mailto:dummy@gmail.com"><span class="icon-Mail-notification me-5 text-success"><span class="path1"></span><span class="path2"></span></span> dummy@gmail.com</a>
                                    <button class="btn btn-success-light btn-sm mt-5"><i class="ti-plus"></i> Follow</button>
                                </div>
                            </div>
                        </div>
                        <div class="dropdown-divider my-30"></div>
                        <div>
                            <div class="d-flex align-items-center mb-30">
                                <div class="me-15 bg-primary-light h-50 w-50 l-h-60 rounded text-center">
                                    <span class="icon-Library fs-24"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                                <div class="d-flex flex-column fw-500">
                                    <a href="#" class="text-dark hover-primary mb-1 fs-16">My Profile</a>
                                    <span class="text-fade">Account settings and more</span>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-30">
                                <div class="me-15 bg-danger-light h-50 w-50 l-h-60 rounded text-center">
                                    <span class="icon-Write fs-24"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                                <div class="d-flex flex-column fw-500">
                                    <a href="#" class="text-dark hover-danger mb-1 fs-16">My Messages</a>
                                    <span class="text-fade">Inbox and tasks</span>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-30">
                                <div class="me-15 bg-success-light h-50 w-50 l-h-60 rounded text-center">
                                    <span class="icon-Group-chat fs-24"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                                <div class="d-flex flex-column fw-500">
                                    <a href="#" class="text-dark hover-success mb-1 fs-16">My Activities</a>
                                    <span class="text-fade">Logs and notifications</span>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-30">
                                <div class="me-15 bg-info-light h-50 w-50 l-h-60 rounded text-center">
                                    <span class="icon-Attachment1 fs-24"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span></span>
                                </div>
                                <div class="d-flex flex-column fw-500">
                                    <a href="#" class="text-dark hover-info mb-1 fs-16">My Tasks</a>
                                    <span class="text-fade">latest tasks and projects</span>
                                </div>
                            </div>
                        </div>
                        <div class="dropdown-divider my-30"></div>
                        <div>
                            <div class="media-list">
                                <a class="media media-single px-0" href="#">
                                    <h4 class="w-50 text-gray fw-500">10:10</h4>
                                    <div class="media-body ps-15 bs-5 rounded border-primary">
                                        <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                        <span class="text-fade">by Johne</span>
                                    </div>
                                </a>

                                <a class="media media-single px-0" href="#">
                                    <h4 class="w-50 text-gray fw-500">08:40</h4>
                                    <div class="media-body ps-15 bs-5 rounded border-success">
                                        <p>Proin iaculis eros non odio ornare efficitur.</p>
                                        <span class="text-fade">by Amla</span>
                                    </div>
                                </a>

                                <a class="media media-single px-0" href="#">
                                    <h4 class="w-50 text-gray fw-500">07:10</h4>
                                    <div class="media-body ps-15 bs-5 rounded border-info">
                                        <p>In mattis mi ut posuere consectetur.</p>
                                        <span class="text-fade">by Josef</span>
                                    </div>
                                </a>

                                <a class="media media-single px-0" href="#">
                                    <h4 class="w-50 text-gray fw-500">01:15</h4>
                                    <div class="media-body ps-15 bs-5 rounded border-danger">
                                        <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                        <span class="text-fade">by Rima</span>
                                    </div>
                                </a>

                                <a class="media media-single px-0" href="#">
                                    <h4 class="w-50 text-gray fw-500">23:12</h4>
                                    <div class="media-body ps-15 bs-5 rounded border-warning">
                                        <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                        <span class="text-fade">by Alaxa</span>
                                    </div>
                                </a>
                                <a class="media media-single px-0" href="#">
                                    <h4 class="w-50 text-gray fw-500">10:10</h4>
                                    <div class="media-body ps-15 bs-5 rounded border-primary">
                                        <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                        <span class="text-fade">by Johne</span>
                                    </div>
                                </a>

                                <a class="media media-single px-0" href="#">
                                    <h4 class="w-50 text-gray fw-500">08:40</h4>
                                    <div class="media-body ps-15 bs-5 rounded border-success">
                                        <p>Proin iaculis eros non odio ornare efficitur.</p>
                                        <span class="text-fade">by Amla</span>
                                    </div>
                                </a>

                                <a class="media media-single px-0" href="#">
                                    <h4 class="w-50 text-gray fw-500">07:10</h4>
                                    <div class="media-body ps-15 bs-5 rounded border-info">
                                        <p>In mattis mi ut posuere consectetur.</p>
                                        <span class="text-fade">by Josef</span>
                                    </div>
                                </a>

                                <a class="media media-single px-0" href="#">
                                    <h4 class="w-50 text-gray fw-500">01:15</h4>
                                    <div class="media-body ps-15 bs-5 rounded border-danger">
                                        <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                        <span class="text-fade">by Rima</span>
                                    </div>
                                </a>

                                <a class="media media-single px-0" href="#">
                                    <h4 class="w-50 text-gray fw-500">23:12</h4>
                                    <div class="media-body ps-15 bs-5 rounded border-warning">
                                        <p>Morbi quis ex eu arcu auctor sagittis.</p>
                                        <span class="text-fade">by Alaxa</span>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /quick_user_toggle -->

        <!-- quick_shop_toggle -->
        <div class="modal modal-right fade" id="quick_shop_toggle" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <div class="px-15 d-flex w-p100 align-items-center justify-content-between">
                            <h4 class="m-0">Shopping Cart</h4>
                            <a href="#" class="btn btn-icon btn-danger-light btn-sm no-shadow" data-bs-dismiss="modal">
                                <span class="fa fa-close"></span>
                            </a>
                        </div>
                    </div>
                    <div class="modal-body px-30 pb-30 bg-white slim-scroll4">
                        <div class="d-flex align-items-center justify-content-between pb-15">
                            <div class="d-flex flex-column me-2">
                                <a href="#" class="fw-600 fs-18 text-hover-primary">Product Name</a>
                                <span class="text-muted">When an unknown printer</span>
                                <div class="d-flex align-items-center mt-2">
                                    <span class="fw-600 me-5 fs-18">$ 125</span>
                                    <span class="text-muted me-5">for</span>
                                    <span class="fw-600 me-2 fs-18">4</span>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon me-2">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon">
                                        <i class="fa fa-plus"></i>
                                    </a>
                                </div>
                            </div>
                            <a href="#" class="flex-shrink-0">
                                <img src="{{ url('admin') }}/images/product/product-1.png" class="avatar h-100 w-100" alt="" />
                            </a>
                        </div>
                        <div class="dropdown-divider"></div>
                        <div class="d-flex align-items-center justify-content-between py-15">
                            <div class="d-flex flex-column me-2">
                                <a href="#" class="fw-600 fs-18 text-hover-primary">Product Name</a>
                                <span class="text-muted">When an unknown printer</span>
                                <div class="d-flex align-items-center mt-2">
                                    <span class="fw-600 me-5 fs-18">$ 125</span>
                                    <span class="text-muted me-5">for</span>
                                    <span class="fw-600 me-2 fs-18">4</span>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon me-2">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon">
                                        <i class="fa fa-plus"></i>
                                    </a>
                                </div>
                            </div>
                            <a href="#" class="flex-shrink-0">
                                <img src="{{ url('admin') }}/images/product/product-2.png" class="avatar h-100 w-100" alt="" />
                            </a>
                        </div>
                        <div class="dropdown-divider"></div>
                        <div class="d-flex align-items-center justify-content-between py-15">
                            <div class="d-flex flex-column me-2">
                                <a href="#" class="fw-600 fs-18 text-hover-primary">Product Name</a>
                                <span class="text-muted">When an unknown printer</span>
                                <div class="d-flex align-items-center mt-2">
                                    <span class="fw-600 me-5 fs-18">$ 125</span>
                                    <span class="text-muted me-5">for</span>
                                    <span class="fw-600 me-2 fs-18">4</span>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon me-2">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon">
                                        <i class="fa fa-plus"></i>
                                    </a>
                                </div>
                            </div>
                            <a href="#" class="flex-shrink-0">
                                <img src="{{ url('admin') }}/images/product/product-3.png" class="avatar h-100 w-100" alt="" />
                            </a>
                        </div>
                        <div class="dropdown-divider"></div>
                        <div class="d-flex align-items-center justify-content-between py-15">
                            <div class="d-flex flex-column me-2">
                                <a href="#" class="fw-600 fs-18 text-hover-primary">Product Name</a>
                                <span class="text-muted">When an unknown printer</span>
                                <div class="d-flex align-items-center mt-2">
                                    <span class="fw-600 me-5 fs-18">$ 125</span>
                                    <span class="text-muted me-5">for</span>
                                    <span class="fw-600 me-2 fs-18">4</span>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon me-2">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon">
                                        <i class="fa fa-plus"></i>
                                    </a>
                                </div>
                            </div>
                            <a href="#" class="flex-shrink-0">
                                <img src="{{ url('admin') }}/images/product/product-4.png" class="avatar h-100 w-100" alt="" />
                            </a>
                        </div>
                        <div class="dropdown-divider"></div>
                        <div class="d-flex align-items-center justify-content-between py-15">
                            <div class="d-flex flex-column me-2">
                                <a href="#" class="fw-600 fs-18 text-hover-primary">Product Name</a>
                                <span class="text-muted">When an unknown printer</span>
                                <div class="d-flex align-items-center mt-2">
                                    <span class="fw-600 me-5 fs-18">$ 125</span>
                                    <span class="text-muted me-5">for</span>
                                    <span class="fw-600 me-2 fs-18">4</span>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon me-2">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon">
                                        <i class="fa fa-plus"></i>
                                    </a>
                                </div>
                            </div>
                            <a href="#" class="flex-shrink-0">
                                <img src="{{ url('admin') }}/images/product/product-5.png" class="avatar h-100 w-100" alt="" />
                            </a>
                        </div>
                        <div class="dropdown-divider"></div>
                        <div class="d-flex align-items-center justify-content-between py-15">
                            <div class="d-flex flex-column me-2">
                                <a href="#" class="fw-600 fs-18 text-hover-primary">Product Name</a>
                                <span class="text-muted">When an unknown printer</span>
                                <div class="d-flex align-items-center mt-2">
                                    <span class="fw-600 me-5 fs-18">$ 125</span>
                                    <span class="text-muted me-5">for</span>
                                    <span class="fw-600 me-2 fs-18">4</span>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon me-2">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                    <a href="#" class="btn btn-sm btn-success-light btn-icon">
                                        <i class="fa fa-plus"></i>
                                    </a>
                                </div>
                            </div>
                            <a href="#" class="flex-shrink-0">
                                <img src="{{ url('admin') }}/images/product/product-6.png" class="avatar h-100 w-100" alt="" />
                            </a>
                        </div>
                    </div>
                    <div class="modal-footer modal-footer-uniform">
                        <div class="d-flex align-items-center justify-content-between mb-10">
                            <span class="fw-600 text-muted fs-16 me-2">Total</span>
                            <span class="fw-600 text-end">$1248.00</span>
                        </div>
                        <div class="d-flex align-items-center justify-content-between mb-15">
                            <span class="fw-600 text-muted fs-16 me-2">Sub total</span>
                            <span class="fw-600 text-primary text-end">$4125.00</span>
                        </div>
                        <div class="text-end">
                            <button type="button" class="btn btn-primary">Place Order</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /quick_shop_toggle -->

    </div>
    <!-- ./wrapper -->
    <form action="{{ route('logout') }}" id="sair" method="post">@csrf</form>
    <!-- Vendor JS -->
    <script src="{{ url('admin') }}/src/js/vendors.min.js"></script>
    <script src="{{ url('admin') }}/src/js/pages/chat-popup.js"></script>
    <script src="{{ url('assets/icons/feather-icons/feather.min.js') }}"></script>

    <script src="{{ url('assets/vendor_components/apexcharts-bundle/dist/apexcharts.js') }}"></script>

    <!-- CRMi App -->
    <script src="{{ url('admin') }}/src/js/template.js"></script>
    {{-- <script src="{{ url('admin') }}/src/js/pages/dashboard.js"></script> --}}

    <script src="{{ url('assets/vendor_components/sweetalert/sweetalert.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/sweetalert/jquery.sweet-alert.custom.js') }}"></script>
    <script>
        function Sair() {
            swal({
                title: "Sair",
                text: "Deseja deslogar do sistema?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Sim",
                closeOnConfirm: false
            }, function() {
                swal("Aguarde...", "Você será direcionado...", "success");
                document.getElementById("sair").submit();
            });
        }
    </script>
    @yield('js')
</body>

</html>
