// Configurar o token CSRF nas requisições AJAX
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

const mp = new MercadoPago('APP_USR-c8a0352f-cb29-4b54-8cf9-a6abc7cb4aa5');
const bricksBuilder = mp.bricks();

const renderPaymentBrick = async (bricksBuilder) => {
    const settings = {
        initialization: {
            amount: 100.50,
        },
        customization: {
            paymentMethods: {
                ticket: "all",
                bankTransfer: "all",
                creditCard: "all",
                debitCard: "all",
                mercadoPago: "all",
            },
        },
        callbacks: {
            onReady: () => {
                // Callback chamado quando o Brick estiver pronto.
            },
            onSubmit: ({ selectedPaymentMethod, formData }) => {
                // Coletar os dados do formulário
                const formDataForm = $('#form_pedido').serializeArray();

                // Combinar os dados do formulário com o formData do MercadoPago
                const finalFormData = {
                    ...formData,
                    ...formDataForm.reduce((acc, { name, value }) => {
                        acc[name] = value;
                        return acc;
                    }, {})
                };

                // Enviar os dados para o servidor
                return new Promise((resolve, reject) => {
                    fetch("https://musaticket.com.br/payment-card", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json",
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // Passando o token CSRF
                        },
                        body: JSON.stringify(finalFormData)
                    })
                        .then(response => response.json())
                        .then(response => {
                            // Processar o resultado do pagamento
                            console.log(response);
                            // return;
                            const renderStatusScreenBrick = async (bricksBuilder) => {
                                const settings = {
                                    initialization: {
                                        paymentId: response.id, // id do pagamento a ser mostrado
                                    },
                                    callbacks: {
                                        onReady: () => {
                                            /*
                                              Callback chamado quando o Brick estiver pronto.
                                              Aqui você pode ocultar loadings do seu site, por exemplo.
                                            */
                                        },
                                        onError: (error) => {
                                            // callback chamado para todos os casos de erro do Brick
                                            console.error(error);
                                        },
                                    },
                                };
                                window.statusScreenBrickController = await bricksBuilder.create(
                                    'statusScreen',
                                    'statusScreenBrick_container',
                                    settings,
                                );
                            };
                            renderStatusScreenBrick(bricksBuilder);
                            resolve();
                        })
                        .catch(error => {
                            // Lidar com erro
                            reject();
                        });
                });
            },
            onError: (error) => {
                // Callback para erros do Brick
                console.error(error);
            },
        },
    };

    window.paymentBrickController = await bricksBuilder.create(
        "payment",
        "paymentBrick_container",
        settings
    );
};

renderPaymentBrick(bricksBuilder);
