$(document).ready(function () {
    $('.form-cc :input, .form-end :input').attr("disabled", true);
    $('input[type="radio"][name="payment_method"]').change(function () {
        $('button.payment-method-btn ').removeClass('active');
        if (this.checked) {
            $(this).closest('button').addClass('active');

            $('.pix-payment-data').hide();
            $('.card-payment-data').hide();
            $('.form-cc, .form-end').hide();
            console.log($(this).val());

            if ($(this).val() == "PIX") {
                $('.pix-payment-data').show();
            } else if ($(this).val() == "CC") {
                $('.card-payment-data').show();
                $('.form-cc, .form-end').show();
                $('.form-cc :input, .form-end :input').attr("disabled", false);
                $('.card-payment-header-title').html('<i class="fa-regular fa-credit-card mr-2"></i> Pagar com Cartão de Crédito');

            } else if ($(this).val() == "B") {
                $('.card-payment-data').show();
                $('.form-cc').hide();
                $('.form-end').show();
                $('.form-cc :input').attr("disabled", true);
                $('.form-end :input').attr("disabled", false);
                $('.card-payment-header-title').html('<i class="fa-solid fa-barcode mr-2"></i> Pagar com Boleto');
            }
        }
    });
    $('.payment-method-btn').click(function () {
        $(this).find('input[type="radio"]').prop('checked', true).change();
    });
});



function processaErros(retorno, erros) {
    for (var fieldname in erros) {
        retorno += '<li class="red">' + erros[fieldname] + '</li>';
        el = $('#form_pedido input[name="' + fieldname + '"], select[name="' + fieldname + '"]');
        el.addClass('field-error');
    }
    return retorno;
}

function processaErrosIngressos(retorno, erros) {
    for (var k in erros) {
        for (var field in erros[k]) {
            let field_name = '[name=form-' + k + '-' + field + ']';
            retorno += '<li class="red">' + erros[k][field] + '</li>';
            $(field_name).addClass('field-error');
        }
    }
    return retorno;
}

function processaErrosIngressosGeral(retorno, erros) {
    for (var erro in erros) {
        retorno += '<li class="red">' + erros[erro] + '</li>';
    }
    return retorno;
}

function exibeErros(rs) {
    $('.checkout-error').remove();
    if (rs.erros) {
        retorno = '<div id="formError" class="alert alert-danger checkout-error" role="alert" style="margin-top:10px">';
        retorno += 'Por favor, corrija o(s) erro(s) abaixo:';
        retorno += '<ul>';

        retorno = processaErrosIngressos(retorno, rs.erros['formIngressos'])
        retorno = processaErrosIngressosGeral(retorno, rs.erros['formIngressosGeral'])
        retorno = processaErros(retorno, rs.erros['formComprador'])
        retorno = processaErros(retorno, rs.erros['formEnd'])
        retorno = processaErros(retorno, rs.erros['formCC'])
        retorno = processaErros(retorno, rs.erros['formBoleto'])
        retorno = processaErros(retorno, rs.erros['formPix'])
        retorno += '</ul></div>';
        $(retorno).insertAfter($("#form_pedido"));
        $('html, body').animate({
            scrollTop: ($('#formError').first().offset().top - 200)
        }, 500);
        $('#loader').hide();
        $('#btnFinalizar').prop('disabled', false);

        if (rs.erros.reservation_expired == true) {
            seatListCrud(rs.erros.field_id, rs.erros.label, 'remove');
        }
    }
}
