<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pedido extends Model
{
    use HasFactory;
    protected $fillable = [
        'pdv_id',
        'cupom_id',
        'evento_id',
        'user_id',
        'divulgador_id',
        'qtd_pacotes',
        'sub_total',
        'total',
        'taxa',
        'taxa_origen',
        'cupom',
        'desconto',
        'status',
        'forma_pagamento',
        'parcelamento',
        'valor_parcela',
        'nome',
        'cpf',
        'endereco',
        'registro',
        'pdv_user',
        'pdv',
        'check_in_situacao',
        'casadinha',
        'send_email'
    ];

    protected static function booted()
    {
        static::creating(function ($pedido) {
            $pedido->data_pedido = now()->toDateString();
        });
    }


    public function Evento()
    {
        return $this->hasOne(Evento::class, 'id', 'evento_id');
    }

    public function Boleto()
    {
        return $this->hasOne(Boleto::class, 'pedido_id', 'id');
    }

    public function Cliente()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function Cancelamento()
    {
        return $this->hasOne(PedidosCancelados::class, 'pedido_id', 'id');
    }

    public function Ingressos()
    {
        return $this->hasMany(Ingresso::class, 'pedido_id', 'id')->where('check_in_situacao', '0');
    }

    public function IngressosBase()
    {
        return $this->hasMany(Ingresso::class, 'pedido_id', 'id')->where('check_in_situacao', '1');
    }

    public function IngressosCliente()
    {
        return $this->hasMany(Ingresso::class, 'pedido_id', 'id');
    }
}
