<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ingresso extends Model
{
    use HasFactory;
    protected $fillable = [
        'pdv_id',
        'nome_completo',
        'cpf',
        'email',
        'celular',
        'foto',
        'nivel_ensino',
        'curso',
        'instituicao_ensino',
        'pedido_id',
        'user_id',
        'evento_id',
        'pacote_id',
        'terminal_id',
        'setor_id',
        'cupom_id',
        'pdv',
        'preco',
        'taxa',
        'valor_final',
        'cupom',
        'status',
        'code_barras',
        'registro',
        'check_in_status',
        'check_in_data',
        'check_tentativas',
        'check_in_situacao',
        'send_email',
        'campos_personalizados',
        'certificado',
        'status_entrega'
    ];

    public function Cliente()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function Pedido()
    {
        return $this->hasOne(Pedido::class, 'id', 'pedido_id')->where('check_in_situacao', '0');
    }

    public function Evento()
    {
        return $this->hasOne(Evento::class, 'id', 'evento_id');
    }

    public function Pacote()
    {
        return $this->hasOne(EventoPacote::class, 'id', 'pacote_id');
    }

    public function Cupom()
    {
        return $this->hasOne(EventoCupomDesconto::class, 'id', 'cupom_id');
    }

    // protected $casts = [
    //     'campos_personalizados' => 'array',
    // ];

    // public function getInstituicaoEnsinoAttribute()
    // {
    //     return $this->campos_personalizados['instituicao'] ?? '';
    // }

    // public function getCursoAttribute()
    // {
    //     return $this->campos_personalizados['curso'] ?? '';
    // }

    // public function getMatriculaAttribute()
    // {
    //     return $this->campos_personalizados['matricula'] ?? '';
    // }

    // public function getFotoUrlAttribute()
    // {
    //     $foto = $this->campos_personalizados['foto'] ?? null;

    //     if ($foto && file_exists(public_path('storage/' . $foto))) {
    //         return asset('storage/' . $foto);
    //     }

    //     return asset('site/images/sem-foto.jpeg');
    // }
}
