<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventoPacote extends Model
{
    use HasFactory;

    protected $fillable = [
        'evento_id',
        'grupo_id',
        'tipo',
        'sigla',
        'nome',
        'preco',
        'qtd',
        'status',
        'data_inicio',
        'data_fim',
        'qtd_minima_compra',
        'qtd_maxima_compra',
        'qtd_ingressos'
    ];

    public function Evento()
    {
        return $this->hasOne(Evento::class,'id','evento_id');
    }

    public function getPreco()
    {
        return $this->preco;
    }

    public function Ingressos()
    {
        return $this->hasMany(Ingresso::class, 'pacote_id', 'id')->where('check_in_situacao', '0');
    }
}
