<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventoPDV extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'evento_id',
        'pacote_id',
        'nome',
        'status'
    ];

    public function User()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function Pacote()
    {
        return $this->hasOne(EventoPacote::class, 'id', 'pacote_id');
    }
}
