<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventoCupomDesconto extends Model
{
    use HasFactory;

    protected $fillable = [
        'evento_id',
        'cupom',
        'desconto',
        'limite_ingressos',
        'status',
        'situacao',
    ];

    public function Evento()
    {
        return $this->hasOne(Evento::class, 'id', 'evento_id');
    }

    public function Pedidos()
    {
        return $this->hasMany(Pedido::class, 'cupom_id', 'id')->where('status', 'Aprovado');
    }

    public function PedidosPendentes()
    {
        return $this->hasMany(Pedido::class, 'cupom_id', 'id')->where('status', 'Pendente');
    }

    public function Ingressos()
    {
        return $this->hasMany(Ingresso::class, 'cupom_id', 'id')->where('status', '1');
    }
}
