<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Evento extends Model
{
    use HasFactory;

    protected $fillable = [
        'categoria_id',
        'produtor_id',
        'taxa_servico',
        'tipo',
        'banner',
        'banner_principal',
        'titulo',
        'descricao',
        'status',
        'data_inicio',
        'data_fim',
        'url',
        'local_id',
        'local',
        'endereco_site',
        'endereco',
        'numero',
        'complemento',
        'bairro',
        'cidade',
        'estado',
        'cep',
        'qtd_pacotes',
        'views',
        'analytics',
        'ads',
        'pixel',
        'mensagem_ingresso',
        'latitude',
        'longitude',
        'publico_alvo',
        'genero',
        'tema',
        'produtora',
        'rule_off',
        'mapa',
        'captacao_aberta',
        'advance',
        'descricao_captacao'
    ];

    public function Categoria()
    {
        return $this->hasOne(Categoria::class, 'id', 'categoria_id');
    }

    public function Pacotes()
    {
        return $this->hasMany(EventoPacote::class, 'evento_id', 'id');
    }


    public function pacoteMaisBarato()
    {
        return $this->hasMany(EventoPacote::class, 'evento_id', 'id')->orderBy('preco');
    }


    public function Grupos()
    {
        return $this->hasMany(EventoGrupoPacote::class, 'evento_id', 'id');
    }

    public function Ingressos()
    {
        return $this->hasMany(Ingresso::class, 'evento_id', 'id')->where('check_in_situacao', '0');
    }

    public function IngressosPagos()
    {
        return $this->hasMany(Ingresso::class, 'evento_id', 'id')->where('status', '1');
    }

    public function IngressosBase()
    {
        return $this->hasMany(Ingresso::class, 'pedido_id', 'id')->where('check_in_situacao', '1');
    }

    public function Pedidos()
    {
        return $this->hasMany(Pedido::class, 'evento_id', 'id')
            ->where('check_in_situacao', '0')
            ->when(
                auth()->check() && auth()->user()->produtor_id,
                function ($query) {
                    $query->where('pdv_id', auth()->user()->produtor_id);
                }
            );
    }


    public function Colaboradores()
    {
        return $this->hasMany(EventoColaborador::class, 'evento_id', 'id');
    }

    public function PDVs()
    {
        return $this->hasMany(EventoPDV::class, 'evento_id', 'id');
    }

    public function Cupons()
    {
        return $this->hasMany(EventoCupomDesconto::class, 'evento_id', 'id');
    }

    public function Repasses()
    {
        return $this->hasMany(Repasse::class, 'evento_id', 'id');
    }

    public function CamposPersonalizados()
    {
        return $this->hasMany(InscricaoCampos::class, 'evento_id', 'id');
    }
}
