<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmailResposta extends Model
{
    use HasFactory;
    protected $fillable = [
        'email_id', 
        'remetente_id',
        'email_destinatario_id',
        'msg',
        'status'
    ];

    function Remetente(){
        return $this->hasOne(User::class,'id','remetente_id');
    }

    function Respostas(){
        return $this->hasOne(EmailResposta::class,'email_id','id');
    }

    function Anexos() {
        return $this->hasMany(EmailRespostaAnexo::class,'resposta_id','id')->orderBy('id','desc');
    }

}
