<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmailDestinatario extends Model
{
    use HasFactory;
    protected $fillable = [
        'email_id',
        'user_id',
        'status',
        'views',
        'status_envio',
    ];

    function Email()
    {
        return $this->hasOne(Email::class, 'id', 'email_id');
    }

    function Respostas()
    {
        return $this->hasMany(EmailResposta::class, 'email_destinatario_id', 'id');
    }

    function Destinatario()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}
