<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Analytics extends Model
{
    use HasFactory;
    protected $fillable = [
        'session_id',
        'user_id',
        'evento_id',
        'url',
        'ip_address',
        'user_agent',
        'referer',
        'views'
    ];

    public function User()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function Evento()
    {
        return $this->hasOne(Evento::class, 'id', 'evento_id');
    }
}
