<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class VerificaProdutorDoEvento
{
    public function handle($request, Closure $next)
    {
        $evento = $request->route('evento'); // nome do parâmetro da rota

        if (Auth::check() && Auth::user()->nivel == '2') {
            if ($evento->produtor_id != Auth::user()->produtor_id) {
                return redirect()->route('dashboard');
            }
        }

        return $next($request);
    }
}
