<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;

class RedirectInvalidGetRequests
{
    public function handle(Request $request, Closure $next)
    {
        // Apenas se for GET
        if ($request->isMethod('get')) {
            try {
                $route = app('router')->getRoutes()->match($request);

                // Se a rota existe, mas não aceita GET, redireciona
                if (!in_array('GET', $route->methods())) {
                    return redirect('/'); // ou para uma view personalizada
                }

            } catch (MethodNotAllowedHttpException $e) {
                return redirect('/');
            } catch (\Throwable $e) {
                // Se não encontrar a rota, ignora e segue fluxo normal
            }
        }

        return $next($request);
    }
}
