<?php

namespace App\Http\Controllers;

use App\Models\Evento;
use App\Models\Ingresso;
use App\Models\Pedido;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Mail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Password as PasswordRule;

class UserController extends Controller
{
    public function store(Request $request)
    {
        $dados = $request->all();
        // dd($request->all());
        $user = User::where('email', $request->email)->first();
        if ($user) {
            return response()->json([
                'error' => 'O e-mail ' . $request->email . ' já está em uso',
            ]);
        }

        $nomeCompleto = $request->name;
        $nomeSeparado = explode(' ', $nomeCompleto);
        $primeiroNome = $nomeSeparado[0];
        $sobreNome = implode(' ', array_slice($nomeSeparado, 1));

        $token = gerarCodigo(6);
        $dados['nivel'] = '3';
        $dados['status'] = 'Cadastro';
        $dados['password'] = bcrypt($request->password);
        $dados['name'] = $primeiroNome;
        $dados['sobrenome'] = $sobreNome;
        $dados['token'] = $token;

        $user = User::create($dados);

        // Enviar email de ativação
        try {
            Mail::send('emails.ativacao-conta', [
                'name' => $primeiroNome,
                'email' => $request->email,
                'token' => $token,
                'empresa' => env('APP_EMPRESA'),
            ], function ($mail) use ($request) {
                $mail->from(env('MAIL_USERNAME'), env('APP_EMPRESA'));
                $mail->to($request->email)->subject('Bem-vindo a UCESUB - Ative sua conta');
            });
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Ocorreu um erro ao enviar o email de ativação, por favor tente novamente'
            ]);
        }

        // Login automático após o registro
        Auth::login($user);
    }

    public function perfil()
    {
        $eventos = Evento::where('status', 'Ativo')->get();

        // dd(Auth::user());
        return view('cliente.meus-dados', compact('eventos'));
    }

    public function RecoverStore(Request $request)
    {
        # code...
    }

    public function compras()
    {
        $pedidos = Pedido::where('user_id', Auth::user()->id)->get();
        return view('cliente.compras', compact('pedidos'));
    }

    public function dados()
    {
        return view('cliente.perfil');
    }
    public function dadosedit()
    {
        return view('cliente.dados-edit');
    }

    public function update(Request $request)
    {
        $user = Auth::user();

        // Normaliza campos (mantido como estava)
        $cpf      = preg_replace('/\D/', '', (string) $request->input('cpf'));
        $rg       = preg_replace('/\D/', '', (string) $request->input('rg'));
        $celular  = preg_replace('/\D/', '', (string) $request->input('celular'));
        $cep      = preg_replace('/\D/', '', (string) $request->input('cep'));
        $estado   = strtoupper((string) $request->input('estado'));
        $email    = strtolower((string) $request->input('email'));

        $request->merge([
            'cpf'     => $cpf,
            'rg'      => $rg,
            'celular' => $celular,
            'cep'     => $cep,
            'estado'  => $estado,
            'email'   => $email,
        ]);

        // Não há mais validação nenhuma
        $nomeCompleto = trim((string) $request->input('nome'));
        $partes       = preg_split('/\s+/', $nomeCompleto, -1, PREG_SPLIT_NO_EMPTY);

        $primeiroNome = $partes ? array_shift($partes) : '';
        $sobrenome    = $partes ? implode(' ', $partes) : '';

        // Monta payload direto do request
        $payload = [
            'name'                => $primeiroNome,
            'sobrenome'           => $sobrenome,
            'nascimento'          => $request->input('nascimento'),
            'cpf'                 => $request->input('cpf'),
            'rg'                  => $request->input('rg'),
            'celular'             => $request->input('celular'),
            'sexo'                => $request->input('sexo'),
            'cep'                 => $request->input('cep'),
            'endereco'            => $request->input('endereco'),
            'numero'              => $request->input('numero'),
            'complemento'         => $request->input('complemento'),
            'bairro'              => $request->input('bairro'),
            'cidade'              => $request->input('cidade'),
            'estado'              => $request->input('estado'),
            'email'               => $request->input('email'),
            'update_cpf'          => '1',
            'verificar_whatsapp'  => $user->celular == $request->celular ? $user->verificar_whatsapp : '0',
            'verificar_email'     => $user->email == $request->email ? $user->verificar_email : '0',
        ];

        // FOTO
        if ($request->foto) {
            $file     = $request->file('foto');
            $filename = Str::slug(($primeiroNome ?: 'usuario') . '-' . ($sobrenome ?: '') . '-' . $user->id . rand());
            $filename = trim($filename, '-') . '.' . $file->guessExtension();
            $path     = $file->storeAs('usuarios', $filename, 'public');
            $payload['foto'] = env('BASE_STORAGE') . $path;
        }

        // Senha (somente atualiza se enviada)
        if ($request->filled('password') && $request->filled('password_confirmation')) {
            if ($request->password === $request->password_confirmation) {
                $payload['password'] = bcrypt($request->password);
            }
        }

        $user->update($payload);

        // === SINCRONIZA INGRESSOS DO USUÁRIO ===
        $nomeCompletoFinal = trim($primeiroNome . ' ' . $sobrenome);

        $ingressos = Ingresso::where('user_id', $user->id)->get();

        foreach ($ingressos as $ingresso) {

            // Atualiza campos diretos do ingresso
            $ingresso->nome_completo = $nomeCompletoFinal;
            $ingresso->cpf           = $payload['cpf'] ?? $ingresso->cpf;
            $ingresso->email         = $payload['email'] ?? $ingresso->email;
            $ingresso->celular       = $payload['celular'] ?? $ingresso->celular;

            // Atualiza foto dentro do JSON campos_personalizados
            if (isset($payload['foto'])) {
                $campos = $ingresso->campos_personalizados ?? [];
                // garante array mesmo se vier null
                if (!is_array($campos)) {
                    $campos = [];
                }
                $campos['foto'] = $payload['foto'];
                // atribui direto (Laravel faz o encode)
                $ingresso->campos_personalizados = $campos;
            }
            $ingresso->save();
        }


        return redirect()->route('cliente.ingressos');
    }



    public function UpdateNotification(Request $request)
    {
        $user = User::find(Auth::user()->id);
        if ($request->notification == 'notification_email') {
            if ($user->notification_email == '1') {
                $user->update(['notification_email' => '0']);
            } else {
                $user->update(['notification_email' => '1']);
            }
        }
        if ($request->notification == 'notification_whatsapp') {
            if ($user->notification_whatsapp == '1') {
                $user->update(['notification_whatsapp' => '0']);
            } else {
                $user->update(['notification_whatsapp' => '1']);
            }
        }
    }

    public function password(Request $request)
    {
        $request->validate([
            'password'               => ['required', 'current_password:web'],
            'password_new'           => ['required', PasswordRule::defaults(), 'different:password'],
            'password_new_confirme'  => ['required', 'same:password_new'],
        ], [
            'password.required'                  => 'Informe sua senha atual.',
            'password.current_password'          => 'A senha atual está incorreta.',
            'password_new.required'              => 'Informe a nova senha.',
            'password_new.different'             => 'A nova senha deve ser diferente da atual.',
            'password_new_confirme.required'     => 'Confirme a nova senha.',
            'password_new_confirme.same'         => 'As senhas devem ser iguais.',
        ]);

        Auth::user()->update([
            'password' => Hash::make($request->password_new),
        ]);

        return back()->with('success', 'Senha atualizada com sucesso.');
    }
    public function compra($id)
    {
        $pedido = Pedido::where('id', $id)->where('user_id', Auth::user()->id)->first();

        // dd($pedido->Pacote);

        if ($pedido) {
            return view('cliente.compra', ['pedido' => $pedido]);
        } else {
            return view('site.404');
        }
    }

    public function verificacao()
    {
        return view('cliente.verificacao');
    }


    public function ValidarEmail()
    {
        $token  = gerarCodigo(6);
        $user   = User::find(Auth::user()->id);
        $user->update([
            'token' => $token
        ]);

        Mail::send('emails.validar-conta', [
            'name' => Auth::user()->name,
            'email' =>  Auth::user()->email,
            'token' => $token,
            'empresa' => env('APP_EMPRESA'),
            'validacao' => 'email',
        ], function ($mail) use ($user) {
            $mail->from(env('MAIL_USERNAME'), env('APP_EMPRESA'));
            $mail->to($user->email)->subject('Bem-vindo a UCESUB - Ative sua conta');
        });

        return view('cliente.validar-cadastro');
    }

    public function ValidarTokenEmail(Request $request)
    {
        $user = User::find(Auth::user()->id);
        if ($user->token == $request->token) {
            $user->update([
                'verificar_email' => '1',
                'token' => '',
            ]);
            return 'ok';
        } else {
            return 'error';
        }
    }


    public function ValidarCelular()
    {
        $token  = gerarCodigo(6);
        $user   = User::find(Auth::user()->id);
        $user->update([
            'token' => $token
        ]);

        $payload = [
            'nome'  => trim(($user->name ?? '') . ' ' . ($user->sobrenome ?? '')),
            'token' => $token,
            'celular' => '55' . tiraMoeda($user->celular),
        ];

        $url = 'https://new-backend.botconversa.com.br/api/v1/webhooks-automation/catch/117946/ghPNtn1HKhg0/';

        try {
            // Envio em JSON (padrão do Http::post). Se o endpoint exigir form-data, use ->asForm()
            $response = Http::timeout(10)
                ->retry(2, 300) // 2 tentativas, 300ms entre elas
                ->post($url, $payload);

            if (! $response->successful()) {
                Log::warning('Falha ao disparar webhook BotConversa', [
                    'status' => $response->status(),
                    'body'   => $response->body(),
                ]);
            }
        } catch (\Throwable $e) {
            Log::error('Erro no disparo do webhook BotConversa', [
                'erro' => $e->getMessage(),
            ]);
        }


        return view('cliente.validar-celular');
    }

    public function ValidarTokenCelular(Request $request)
    {
        $user = User::find(Auth::user()->id);
        if ($user->token == $request->token) {
            $user->update([
                'verificar_whatsapp' => '1',
                'token' => '',
            ]);
            return 'ok';
        } else {
            return 'error';
        }
    }

    public function indicacoes()
    {
        return view('cliente.indicacoes');
    }
}
