<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Rede\Store;
use Rede\Environment;
use Rede\eRede;
use Rede\Transaction;

class RedeController extends Controller
{
    public function authorizeTransaction()
    {
        $store = new Store(env('REDE_PV'), env('REDE_TOKEN'), Environment::sandbox());

        $transaction = new Transaction(10000, 'pedido1714180249');
        $transaction->creditCard(
            '5111111111111100', // Número do cartão de teste
            '100',              // CVV
            '12',               // Mês de expiração
            '2024',             // Ano de expiração
            'Fulano de Tal'     // Nome do portador
        );

        // Autoriza a transação
        $transaction = (new eRede($store))->create($transaction);

        // Checa o resultado da transação
        if ($transaction->getReturnCode() === '00') {
            return response()->json([
                'success' => true,
                'message' => 'Transação autorizada com sucesso',
                'tid' => $transaction->getTid()
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Falha na autorização da transação',
                'error_code' => $transaction->getReturnCode()
            ]);
        }
    }
}
