<?php

namespace App\Http\Controllers;

use App\Models\Email;
use App\Models\EmailDestinatario;
use App\Models\Evento;
use App\Models\Pedido;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Mail;

class EmailMarketingController extends Controller
{
    public function EmailStore(Request $request)
    {
        $Evento = Evento::find($request->evento_id);

        // 🔹 Cadastra o e-mail base
        $Email = Email::create([
            'evento_id'  => $request->evento_id,
            'user_id'    => Auth::user()->id,
            'assunto'    => $request->assunto,
            'msg'        => $request->msg,
            'link_final' => $request->link_final,
        ]);

        // 🔹 Caso o tipo de destinatário seja "Meus Clientes"
        if ($request->destinatarios == 'Meus Clientes') {

            // 1️⃣ Buscar todos os eventos com o mesmo local_id
            $eventosMesmoLocal = Evento::where('local_id', $Evento->local_id)->pluck('id');

            // 2️⃣ Buscar todos os pedidos relacionados a esses eventos
            $pedidos = Pedido::whereIn('evento_id', $eventosMesmoLocal)
                ->whereIn('status', ['Aprovado']) // opcional, se quiser filtrar pagos
                ->get();

            // dd($pedidos);

            // 3️⃣ Obter todos os user_id desses pedidos
            $userIds = $pedidos->pluck('user_id')->unique()->values();

            // 4️⃣ Cadastrar cada user_id em EmailDestinatario (sem duplicar)
            foreach ($userIds as $uid) {
                EmailDestinatario::firstOrCreate([
                    'email_id' => $Email->id,
                    'user_id'  => $uid,
                ], [
                    'status' => '0',
                    'views'  => 0,
                ]);
            }
        }

        // 🔹 Outros tipos de destinatários
        if ($request->destinatarios == 'Clientes Musa') {
            $Users = User::where('nivel', '3')->get();
            foreach ($Users as $lead) {
                EmailDestinatario::firstOrCreate([
                    'email_id' => $Email->id,
                    'user_id'  => $lead->id,
                ], [
                    'status' => '0',
                    'views'  => 0,
                ]);
            }
        }

        if ($request->destinatarios == 'Compradores deste evento') {
            $pedidos = Pedido::where('evento_id', $request->evento_id)->get();
            $userIds = $pedidos->pluck('user_id')->unique()->values();

            foreach ($userIds as $uid) {
                EmailDestinatario::firstOrCreate([
                    'email_id' => $Email->id,
                    'user_id'  => $uid,
                ], [
                    'status' => '0',
                    'views'  => 0,
                ]);
            }
        }

        // dd($Email, $request->all());
        return redirect()->route('email.marketing.status', [$Evento, $Email])
            ->with('success', 'Envio em andamento');
    }


    public function status(Evento $Evento, Email $Email)
    {
        return view('admin.email-marketing.status', ['Email' => $Email, 'Evento' => $Evento]);
    }

    function SendEmail(Request $request)
    {
        return;
        $evento = Evento::find($request->evento_id);
        $destinatarios = EmailDestinatario::where('email_id', $request->id)->where('status_envio', '0')->take(20)->get();
        foreach ($destinatarios as $exe) {

            $nomeCompleto = $exe->Destinatario->nome;
            $nomeSeparado = explode(' ', $nomeCompleto);
            $primeiroNome = $nomeSeparado[0];
            $sobreNome = implode(' ', array_slice($nomeSeparado, 1));
            // $email = $exe->Destinatario->email;
            $assunto = $exe->Email->assunto;
            $email = 'rbetobrito@gmail.com';

            try {
                Mail::send('emails.email-marketing', [
                    'nome' => $primeiroNome,
                    'email' => $email,
                    'link' => 'https://checkout.ucesub.com.br/campanha/' . $exe->email_id . '/' . $exe->id,
                    'msg' => $exe->Email->msg,
                    'anexo' => $evento->banner
                ], function ($message) use ($primeiroNome, $email, $assunto) {
                    $message->from('nao-responsa@ucesub.com.br', env('APP_NAME'));
                    $message->to($email)->subject($assunto);
                });

                $exe->update(['status_envio' => '1']);
            } catch (\Exception $e) {
                $exe->update(['status_envio' => '1']);
            }
        }

        $qtd = EmailDestinatario::where('email_id', $request->id)->where('email_id', $request->id)
            ->where('status', '1') // enviados
            ->count();

        return;
    }

    function campanha($email_id, $id)
    {
        $exe = EmailDestinatario::find($id);
        $exe->update(['status' => '1', 'views' => $exe->views + 1]);
        return redirect($exe->Email->link_final);
    }
}
