<?php

namespace App\Http\Controllers;

use App\Models\Boleto;
use App\Models\Comissao;
use App\Models\EventoPacote;
use App\Models\Ingresso;
use App\Models\Pedido;
use App\Models\User;
use Illuminate\Http\Request;
use Mail;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class CronController extends Controller
{


    protected function sendPushNotification($expoPushToken, $title, $body, $data = [])
    {
        $pushController = app(PushController::class);
        $request = new Request([
            'expoPushToken' => $expoPushToken,
            'title' => $title,
            'body' => $body,
            'data' => $data,
        ]);

        $pushController->sendNotification($request);
    }


    public function GerarIngressoPacote()
    {
        $pedidos = Pedido::where('status', 'Aprovado')->with('Ingressos', 'Ingressos.Pacote')->get();
        foreach ($pedidos as $pedido) {
            foreach ($pedido->Ingressos as $ingressoOriginal) {
                $pacote = $ingressoOriginal->Pacote;

                if (!$pacote || $pacote->qtd_ingressos <= 1) {
                    continue; // não precisa gerar novos ingressos
                }

                // Conta quantos ingressos já existem para este pedido/pacote
                $ingressosExistentes = $pedido->Ingressos->where('pacote_id', $pacote->id)->count();

                if ($ingressosExistentes < $pacote->qtd_ingressos) {
                    $faltando = $pacote->qtd_ingressos - $ingressosExistentes;

                    // Atualiza o ingresso original com valores divididos
                    $ingressoOriginal->update([
                        'preco'       => $ingressoOriginal->Pacote->preco / $ingressoOriginal->Pacote->qtd_ingressos,
                        'taxa'        => porcentagem($ingressoOriginal->Evento->taxa_servico, $ingressoOriginal->Pacote->preco) / $ingressoOriginal->Pacote->qtd_ingressos,
                        'valor_final' => porcentagem($ingressoOriginal->Evento->taxa_servico, $ingressoOriginal->Pacote->preco)  / $ingressoOriginal->Pacote->qtd_ingressos,
                    ]);

                    // Cria os ingressos faltantes
                    for ($i = 0; $i < $faltando; $i++) {
                        Ingresso::create([
                            'cupom_id'          => $ingressoOriginal->cupom_id,
                            'cupom'             => $ingressoOriginal->cupom,
                            'nome_completo'     => $ingressoOriginal->nome_completo,
                            'pdv'               => $ingressoOriginal->pdv,
                            'cpf'               => $ingressoOriginal->cpf,
                            'email'             => $ingressoOriginal->email,
                            'pedido_id'         => $ingressoOriginal->pedido_id,
                            'user_id'           => $ingressoOriginal->user_id,
                            'evento_id'         => $ingressoOriginal->evento_id,
                            'pacote_id'         => $ingressoOriginal->pacote_id,
                            'preco'             => $ingressoOriginal->preco,
                            'taxa'              => $ingressoOriginal->taxa,
                            'valor_final'       => $ingressoOriginal->valor_final,
                            'status'            => $ingressoOriginal->status,
                            'code_barras'       => gerarCodigo(12),
                            'registro'          => gerarlETRARegistro(12),
                            'check_in_status'   => $ingressoOriginal->check_in_status,
                            'check_in_data'     => $ingressoOriginal->check_in_data,
                            'check_tentativas'  => $ingressoOriginal->check_tentativas,
                        ]);
                    }
                }
            }
        }
    }

    public function AjustarCasadinha() {}




    public function GerarCasadinhas()
    {
        $ingressos = Ingresso::whereIN('pacote_id', [188, 219, 231])->get();
        foreach ($ingressos as $ingresso) {
            $pedido = Pedido::find($ingresso->pedido_id);
            // dd($ingresso->getOriginal(), $pedido->getOriginal());
            if (count($pedido->IngressosCliente) == $ingresso->Pacote->qtd_ingressos) {
            } else {
                $total = $ingresso->Pacote->qtd_ingressos - count($pedido->IngressosCliente);
                for ($i = 1; $i <= $total; $i++) {
                    Ingresso::create([
                        'nome_completo' => $ingresso->nome_completo,
                        'cpf' => $ingresso->cpf,
                        'email' => $ingresso->email,
                        'pedido_id' => $ingresso->pedido_id,
                        'user_id' => $ingresso->user_id,
                        'evento_id' => $ingresso->evento_id,
                        'pacote_id' => $ingresso->pacote_id,
                        'preco' => $ingresso->preco,
                        'taxa' => $ingresso->taxa,
                        'status' => $ingresso->status,
                        'code_barras'       => gerarCodigo(12),
                        'registro'          => gerarlETRARegistro(12),
                        'check_in_status'   => $ingresso->check_in_status,
                        'check_in_data'     => $ingresso->check_in_data,
                        'check_tentativas'  => $ingresso->check_tentativas,
                        'check_in_situacao'  => $ingresso->check_in_situacao,
                    ]);
                }
            }
        }
    }


    public function VerificaPagamentos($token)
    {
        if ($token != env('JWT_SECRET')) {
            return response()->json(['error' => 'Token inválido'], 401);
        }

        $accessToken = env('ACCESS_TOKEN');
        $boletos = Boleto::where('status', '0')
            ->where('status_cron', '0')
            ->whereDate('created_at', date('Y-m-d'))
            ->take(1)
            ->orderby('id', 'desc')
            ->get();

        foreach ($boletos as $boleto) {
            $boleto->update(['status_cron' => '1']);
            $payment_id = $boleto->payment_id;

            try {
                $response = Http::withToken($accessToken)
                    ->get("https://api.mercadopago.com/v1/payments/" . $boleto->payment_id);

                if ($response->failed()) {
                    Log::error('Falha ao consultar pagamento.', [
                        'payment_id' => $payment_id,
                        'status' => $response->status(),
                        'body' => $response->body(),
                    ]);
                    continue; // Pula para o próximo boleto
                }

                $dados = $response->json();
                $statusPagamento = $dados['status'] ?? null;

                if ($statusPagamento === 'approved') {
                    $Boleto = Boleto::where('payment_id', $payment_id)->first();
                    if (!$Boleto) {
                        Log::warning('Boleto não encontrado para o payment_id: ' . $payment_id);
                        continue;
                    }

                    $Pedido = Pedido::find($Boleto->pedido_id);
                    if (!$Pedido) {
                        Log::warning('Pedido não encontrado para o boleto: ' . $Boleto->id);
                        continue;
                    }

                    // Atualiza boleto e pedido
                    $Boleto->update([
                        'status'    => '1',
                        'data_pago' => date('Y-m-d'),
                    ]);
                    $Pedido->update(['status' => 'Aprovado']);

                    foreach ($Pedido->Ingressos as $ingresso) {
                        $ingresso->update(['status' => '1']);

                        // RULE OFF
                        if (!empty($ingresso->Evento->rule_off) && ($getway->tipo ?? null) === 'pf') {
                            $ingresso->update(['check_in_situacao' => '1']);
                            $Pedido->update(['check_in_situacao' => '1']);
                            foreach ($Pedido->Ingressos as $ddx) {
                                $ddx->update(['check_in_situacao' => '1']);
                            }
                        }

                        $user = User::find($ingresso->user_id);
                        if (!$user) {
                            Log::warning('Usuário não encontrado para ingresso: ' . $ingresso->id);
                            continue;
                        }

                        // Envia e-mail
                        try {
                            Mail::send('emails.usuario-pdv', [
                                'name'      => $user->name,
                                'email'     => $user->email,
                                'evento'    => $Pedido->Evento->titulo,
                                'banner'    => $Pedido->Evento->banner,
                                'link'      => 'https://checkout.ucesub.com.br/print/ingressos/' . $Pedido->registro,
                                'qtd'       => count($Pedido->Ingressos),
                                'ref'       => count($Pedido->Ingressos) . ' ingresso(s) ' . $Pedido->Evento->titulo,
                            ], function ($mail) use ($user) {
                                $mail->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
                                $mail->to($user->email)->subject('Ingresso ' . env('APP_NAME'));
                            });
                        } catch (\Exception $e) {
                            Log::error('Erro ao enviar e-mail para usuário ' . $user->email . ': ' . $e->getMessage());
                        }

                        // Envia push notification
                        if (!empty($user->pushToken)) {
                            foreach ($user->pushToken as $push) {
                                if ($push->token) {
                                    $this->sendPushNotification(
                                        $push->token,
                                        $user->name . ', ingresso disponível!',
                                        $Pedido->Evento->titulo . ' te espera! Acesse o app e confira seu ingresso.',
                                        [
                                            'evento_id'  => $Pedido->Evento->id,
                                        ]
                                    );
                                }
                            }
                        }
                    }
                }
            } catch (\Exception $e) {
                Log::error('Erro ao processar payment_id ' . $payment_id . ': ' . $e->getMessage());
                continue; // Pula para o próximo boleto em caso de erro
            }
        }

        return response()->json([
            'success' => true,
            'boletos' => count($boletos),
            'message' => 'Verificação de pagamentos concluída.',
        ]);
    }

    public function time()
    {
        return view('time');
    }

    public function ValorComissao($token)
    {
        if ($token != env('JWT_SECRET')) {
            return response()->json(['error' => 'Token inválido'], 401);
        }

        $accessToken = env('ACCESS_TOKEN');
        $boletos = Boleto::where('status', '1')
            ->where('status_comissao', '0')
            ->take(1)
            ->get();


        if (count($boletos) < 1) {
            return redirect()->route('site.home');
        }

        foreach ($boletos as $boleto) {
            $payment_id = $boleto->payment_id;


            try {
                $response = Http::withToken($accessToken)
                    ->get("https://api.mercadopago.com/v1/payments/" . $boleto->payment_id);

                if ($response->failed()) {

                    $boleto->update(['status_comissao' => '1']);
                    return redirect()->route('time');
                }

                $dados = $response->json();

                // dd($dados, $boleto);
                $statusPagamento = $dados['status'] ?? null;
                $taxa = tiraMoeda($dados['fee_details'][0]['amount']);
                $total_receber = tiraMoeda(tiraMoeda($dados['transaction_details']['net_received_amount']));
                $comissao_devida = porcentagem($boleto->Pedido->Evento->taxa_servico, $boleto->Pedido->sub_total);

                Comissao::create([
                    'pedido_id'         => $boleto->pedido_id,
                    'boleto_id'         => $boleto->id,
                    'total_pedido'      => $boleto->Pedido->sub_total,
                    'total_final'       => $boleto->valor,
                    'taxa_bancaria'     => $taxa,
                    'comissao_devida'   => $comissao_devida,
                    'comissao_recebida' => $total_receber - $boleto->Pedido->sub_total
                ]);
                $boleto->update(['status_comissao' => '1']);

                // dd($boleto->getOriginal());
            } catch (\Exception $e) {

                $boleto->update(['status_comissao' => '1']);
                return redirect()->route('time');
                dd($e->getMessage());
            }
        }


        return redirect()->route('time');
    }


    public function DeletaCancelados()
    {
        // $pedidos = Pedido::where('status', 'Cancelado')->get();
        // foreach ($pedidos as $pedido) {
        //     if ($pedido->Cancelamento) {
        //         dd($pedido->Cancelamento);
        //     } else {
        //         $pedido->delete();
        //     }
        // }
    }
}
