<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ClienteController extends Controller
{
    public function logar(User $User)
    {
        Auth::login($User, true);
        return redirect()->route('cliente.ingressos');
    }

    public function index()
    {
        return view('admin.clientes.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function result(Request $request)
    {
        $cliente = $request->cliente;
        $clientes = User::where(function ($query) use ($cliente) {
            $nomeSeparado = explode(' ', trim($cliente));
            $primeiroNome = $nomeSeparado[0] ?? null;
            $sobrenome = isset($nomeSeparado[1]) ? implode(' ', array_slice($nomeSeparado, 1)) : null;

            if ($primeiroNome && $sobrenome) {
                $query->where(function ($subquery) use ($primeiroNome, $sobrenome) {
                    $subquery->where('name', 'LIKE', "%{$primeiroNome}%")
                        ->where('sobrenome', 'LIKE', "%{$sobrenome}%");
                });
            } else {
                $query->where('name', 'LIKE', "%{$cliente}%")
                    ->orWhereRaw("CONCAT(name, ' ', sobrenome) LIKE ?", ["%{$cliente}%"]);
            }

            $query->orWhere('cpf', formatCnpjCpf($cliente))
                ->orWhere('celular', $cliente)
                ->orWhere('email', $cliente)
                ->orWhere('id', $cliente)
                ->orWhere('nivel', '1');
        })->get();


        return view('admin.clientes.ajax.cliente', compact('clientes'));
    }



    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }


    public function show(User $User)
    {
        return view('admin.clientes.show', ['User' => $User]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
