<?php

namespace App\Http\Controllers;

use App\Models\EventoPacote;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class CartController extends Controller
{
    public function Add(Request $request)
    {

        $semana = [
            '0' => 'Dom',
            '1' => 'Seg',
            '2' => 'Ter',
            '3' => 'Qua',
            '4' => 'Qui',
            '5' => 'Sex',
            '6' => 'Sab',
        ];

        $pacote = EventoPacote::find($request->id);
        $cart = Session::get('cart', []);
        $cart[$pacote->id] = [
            'evento_id' => $pacote->evento_id,
            'pacote_id' => $request->id,
            'evento' => $pacote->Evento->titulo,
            'pacote' => $pacote->nome,
            'semana' => $semana[date('w', strtotime($pacote->Evento->data_inicio))],
            'dia' => date('d/m/Y', strtotime($pacote->Evento->data_inicio)),
            'preco' => $pacote->preco,
            'qtd' => $request->total,
            'total' => $request->total * $pacote->preco,
        ];
        Session::put('cart', $cart);

        // dd(session()->get('cart', []));

        $total = $request->total * $pacote->preco;
        $taxa = porcentagem(env('TAXA'), $total);
        return response()->json([
            'total_pacote' => 'R$ ' . moeda($total + $taxa),
        ]);
    }

    function Del(Request $request)
    {

        $semana = [
            '0' => 'Dom',
            '1' => 'Seg',
            '2' => 'Ter',
            '3' => 'Qua',
            '4' => 'Qui',
            '5' => 'Sex',
            '6' => 'Sab',
        ];

        // Recupera o carrinho da sessão
        $cart = $request->session()->get('cart', []);

        // Remove o produto do carrinho
        unset($cart[$request->id]);

        // Atualiza a sessão com o carrinho modificado
        $pacote = EventoPacote::find($request->id);
        $cart[$pacote->id] = [
            'evento_id' => $pacote->evento_id,
            'pacote_id' => $request->id,
            'pacote' => $pacote->nome,
            'evento' => $pacote->Evento->titulo,
            'semana' => $semana[date('w', strtotime($pacote->Evento->data_inicio))],
            'dia' => date('d/m/Y', strtotime($pacote->Evento->data_inicio)),
            'preco' => $pacote->preco,
            'qtd' => $request->total,
            'total' => $request->total * $pacote->preco,
        ];
        $request->session()->put('cart', $cart);

        return response()->json([
            'total_pacote' => 'R$ ' . moeda($request->total * $pacote->preco),
        ]);

        return view('site.ajax.carrinho', compact('cart'));
    }

    public function total(Request $request)
    {
        $cart = $request->session()->get('cart', []);
        $sub_total = 0;
        $total_taxa = 0;

        foreach ($cart as $item) {
            if ($item['evento_id'] == $request->id) { // Filtrar apenas itens do evento_id especificado
                $sub_total += $item['total'];
                $total_taxa += porcentagem(env('TAXA'), $item['total']);
            }
        }

        return response()->json([
            'sub_total' => 'R$ ' . moeda($sub_total),
            'total_taxa' => 'R$ ' . moeda($total_taxa),
            'total_geral' => 'R$ ' . moeda($sub_total + $total_taxa),
        ]);
    }


    private function salvarCarrinhoNoBancoDeDados(Request $request)
    {
        // Salva o carrinho no banco de dados de sessões
        $sessionId = $request->session()->getId();
        $payload = base64_encode(serialize($request->session()->all()));

        DB::table('sessions')->updateOrInsert(
            ['id' => $sessionId],
            ['payload' => $payload, 'last_activity' => now()]
        );
    }

    function destoy(Request $request)
    {
        $semana = [
            '0' => 'Dom',
            '1' => 'Seg',
            '2' => 'Ter',
            '3' => 'Qua',
            '4' => 'Qui',
            '5' => 'Sex',
            '6' => 'Sab',
        ];

        $cart = $request->session()->get('cart', []);

        // Remove o produto do carrinho
        if (isset($cart[$request->id])) {
            unset($cart[$request->id]); // Remove o item do carrinho
        }
    
        // Atualiza a sessão com o carrinho modificado
        $request->session()->put('cart', $cart);
        
        // // Atualiza a sessão com o carrinho modificado
        $pacote = EventoPacote::find($request->id);
       

        $total = 0; // Inicializa a variável total
        foreach ($cart as $item) {
            $total += $item['total']; // Soma os valores dos itens restantes
        }

        return view('site.ajax.checkout', compact('cart'),['total' => $total]);
    }

    public function participantes(Request $request){

        $cart = $request->session()->get('cart', []);
        return view('site.ajax.participantes',compact('cart'));
    }
}
