<?php

namespace App\Http\Controllers;

use App\Models\Boleto;
use App\Models\Evento;
use App\Models\User;
use Illuminate\Http\Request;
use Mail;

class CancelamentoEventoController extends Controller
{
    public function RodarCancelamento($id)
    {
        $evento = Evento::find($id);
        foreach ($evento->Pedidos as $pedido) {

            // $pedido->update(['status' => 'Cancelado']);
            $boleto = Boleto::where('pedido_id', $pedido->id)->first();
            // $boleto->update(['status' => '2']);

            foreach ($pedido->Ingressos as $ingresso) {
                // $ingresso->update(['status' => '2']);
            }

            $email = 'rbetobrito@gmail.com';
            // $email = $pedido->Cliente->email;
            Mail::send('emails.comunicado', [
                'evento'   => $evento,
                'name'   => $pedido->Cliente->name,
                'email'  => $email,
                'evento' => $pedido->Evento->titulo,
                'banner' => $pedido->Evento->banner,
            ], function ($mail) use ($pedido, $email, $evento) {
                $mail->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
                $mail->to($email)->subject('Comunicado ' . env('APP_NAME'));
            });

            dd($pedido);
        }
    }
}
