<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     */
    public function store(LoginRequest $request): RedirectResponse
    {
        $request->authenticate();
        $request->session()->regenerate();
        $url = explode('/', $request->evento);
        if (Auth::user()->nivel == '1' || Auth::user()->nivel == '2') {
            return redirect()->route('dashboard');
        } else {
            return redirect()->back();
        }

        // if (Auth::user()->nivel == '1') {
        //     return redirect()->intended(route('dashboard', absolute: false));
        // } else {
        //     if (!empty($url[3]) && $url[3] == 'evento') {
        //         return redirect()->back();
        //     } else {
        //         return redirect()->intended(route('site.home', absolute: false));
        //     }
        // }
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('web')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect('/');
    }
}
