<?php

namespace App\Http\Controllers;

use App\Models\Boleto;
use App\Models\LogPush;
use App\Models\Pedido;
use App\Models\TokenPush;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use GuzzleHttp\Client;
use Mail;

class AsaasController extends Controller
{

    protected function sendPushNotification($expoPushToken, $title, $body, $data = [])
    {
        $pushController = app(PushController::class);
        $request = new Request([
            'expoPushToken' => $expoPushToken,
            'title' => $title,
            'body' => $body,
            'data' => $data,
        ]);
        $pushController->sendNotification($request);
    }

    public function retorno($id)
    {
        $Boleto = Boleto::with(['Pedido', 'Pedido.Ingressos', 'Pedido.Evento'])->find($id);
        if (!$Boleto) {
            return response()->json([
                'success' => false,
                'message' => 'Boleto não encontrado para o ID informado.',
            ], 404);
        }

        if (empty($Boleto->asaas_id)) {
            return response()->json([
                'success' => false,
                'message' => 'Boleto não possui referência ASAAS.',
            ], 400);
        }

        try {
            $client = new \GuzzleHttp\Client();
            $response = $client->get(env('ASAAS_PRODUCAO') . '/v3/payments/' . $Boleto->asaas_id, [
                'headers' => [
                    'accept'       => 'application/json',
                    'access_token' => env('KEYASAASA'),
                ],
            ]);
            $result = json_decode($response->getBody()->getContents(), true);

            $status = strtoupper($result['status'] ?? 'UNKNOWN');

            $Pedido = $Boleto->Pedido;
            if (!$Pedido) {
                return response()->json([
                    'success' => false,
                    'message' => 'Pedido não encontrado.',
                ], 404);
            }

            // Se aprovado no ASAAS (status RECEIVED ou CONFIRMED)
            // , 'PENDING'
            if (in_array($status, ['RECEIVED', 'CONFIRMED'])) {
                $Boleto->update([
                    'status'    => '1',
                    'data_pago' => now()->toDateString(),
                ]);
                $Pedido->update([
                    'status' => 'Aprovado',
                    'vencimento' => Carbon::now()->addDays(30)
                ]);

                $ultimoUsuario = null;
                // foreach ($Pedido->Ingressos as $ingresso) {
                //     $ingresso->update(['status' => '1']);
                //     $user = User::find($ingresso->user_id);
                //     $ultimoUsuario = $user ?: $ultimoUsuario;

                //     if ($user) {
                //         try {
                //             Mail::send('emails.usuario-pdv', [
                //                 'name'   => $user->name,
                //                 'email'  => $user->email,
                //                 'evento' => $Pedido->Evento->titulo,
                //                 'banner' => $Pedido->Evento->banner,
                //                 'link'   => url('print/ingressos/' . $Pedido->registro),
                //                 'qtd'    => $Pedido->Ingressos->count(),
                //                 'ref'    => $Pedido->Ingressos->count() . '-' . $Pedido->Evento->titulo,
                //             ], function ($mail) use ($user) {
                //                 $mail->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
                //                 $mail->to($user->email)->subject('Ingresso ' . env('APP_NAME'));
                //             });
                //         } catch (\Throwable $e) {
                //             Log::warning('Falha ao enviar e-mail de ingresso', [
                //                 'pedido_id' => $Pedido->id,
                //                 'user_id'   => $user->id ?? null,
                //                 'erro'      => $e->getMessage(),
                //             ]);
                //         }
                //     }
                // }

                // Push notification (se disponível)
                // if ($ultimoUsuario && method_exists($this, 'sendPushNotification')) {
                //     foreach ($ultimoUsuario->pushToken as $push) {
                //         if ($push->token) {
                //             $this->sendPushNotification(
                //                 $push->token,
                //                 'Ingresso Disponível',
                //                 'Seu ingresso para ' . $Pedido->Evento->titulo . ' já está disponível.',
                //                 ['evento_id' => $Pedido->Evento->id ?? 1]
                //             );
                //         }
                //     }
                // }

                return response()->json([
                    'success'  => true,
                    'response' => $status,
                    'dados'    => $result,
                    'redirect' => url('success/' . $Pedido->id),
                ]);
            }

            // Para outros status, apenas devolve o status atual
            return response()->json([
                'success'  => true,
                'response' => $status,
                'dados'    => $result,
            ]);
        } catch (\Throwable $e) {
            Log::error('Erro retorno ASAAS', ['erro' => $e->getMessage()]);
            return response()->json([
                'success' => false,
                'message' => 'Erro ao consultar pagamento ASAAS.',
                'error'   => $e->getMessage(),
            ], 500);
        }
    }
}
