<?php

namespace App\Http\Controllers\Ajax;

use App\Http\Controllers\Controller;
use App\Models\Evento;
use App\Models\EventoPacote;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use CodePhix\Asaas\Asaas;

class AjaxControlller extends Controller
{
    public function checkout(Request $request)
    {
        $evento = Evento::find($request->evento);

        $valorTotal = $request->total + 0.49;

        $total = [];
        $total[1] = porcentagem(2.99 + 1.15 + env('TAXA'), $valorTotal);
        $total[2] = porcentagem(3.49 + 1.6 * 2 + env('TAXA'), $valorTotal);
        $total[3] = porcentagem(3.49 + 1.6 * 3 + env('TAXA'), $valorTotal);
        $total[4] = porcentagem(3.49 + 1.6 * 4 + env('TAXA'), $valorTotal);
        $total[5] = porcentagem(3.49 + 1.6 * 5 + env('TAXA'), $valorTotal);
        $total[6] = porcentagem(3.49 + 1.6 * 6 + env('TAXA'), $valorTotal);
        $total[7] = porcentagem(3.99 + 1.6 * 7 + env('TAXA'), $valorTotal);
        $total[8] = porcentagem(3.99 + 1.6 * 8 + env('TAXA'), $valorTotal);
        $total[9] = porcentagem(3.99 + 1.6 * 9 + env('TAXA'), $valorTotal);
        $total[10] = porcentagem(3.99 + 1.6 * 10 + env('TAXA'), $valorTotal);


        $asaas = new Asaas(env('KEYASAASA'), 'producao');
        $cliente = $asaas->Cliente()->getByEmail(auth()->user()->email);

        if (!empty($cliente->data[0])) {
            $cliente = $cliente->data[0]->id;
        } else {
            $dadosCliente = [];
            $dadosCliente['name'] = auth()->user()->name;
            $dadosCliente['email'] = auth()->user()->email;
            $dadosCliente['cpfCnpj'] = auth()->user()->cpf;
            $dadosCliente['notificationDisabled'] = true;

            $cliente = $asaas->Cliente()->create($dadosCliente)->id;
        }

        $valor = moeda($total[$request->installments] + $valorTotal, false, false);
        // dd($valor);

        $dadosCobranca = [];
        $dadosCobranca['customer'] = $cliente;
        $dadosCobranca['billingType'] = "CREDIT_CARD";
        $dadosCobranca['dueDate'] = date("Y-m-d");
        $dadosCobranca['value'] = $valor;
        $dadosCobranca['description'] = "{$evento->titulo}";
        $dadosCobranca['externalReference'] = $evento->id;

        list($expiryMonth, $expiryYear) = explode("/", $request->expiryDate);
        $dadosCobranca['creditCard']['number'] = $request->number;
        $dadosCobranca['creditCard']['holderName'] = $request->holderName;
        $dadosCobranca['creditCard']['expiryMonth'] = $expiryMonth;
        $dadosCobranca['creditCard']['expiryYear'] = $expiryYear;
        $dadosCobranca['creditCard']['ccv'] = $request->ccv;

        $dadosCobranca['creditCardHolderInfo']['name'] = $request->nome;
        $dadosCobranca['creditCardHolderInfo']['postalCode'] = "36010110";
        $dadosCobranca['creditCardHolderInfo']['addressNumber'] = '109';
        $dadosCobranca['creditCardHolderInfo']['addressComplement'] = '';
        $dadosCobranca['creditCardHolderInfo']['phone'] = '3230316269';

        $Cobranca = $asaas->Cobranca()->create($dadosCobranca);

        if (empty($Cobranca->errors)) {
            return response()->json(['status' => 200, 'errors' => false]);
        } else {
            $Erros = [];
            foreach ($Cobranca->errors as $Erro) {
                $Erros[] = $Erro->description;
            }
            return response()->json(['status' => 400, 'errors' => join("<br />\n", $Erros)]);
        }
    }

    public function pix(Request $request)
    {
        $uuid = (string) Str::uuid();
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
            'X-Idempotency-Key' => $uuid,
            'Authorization' => 'Bearer ' . config('services.mercadopago.access_token'), // Use o access token do MP
        ])->post('https://api.mercadopago.com/v1/payments', [
            'transaction_amount' => (int) $request->total,
            'description' => $request->description,
            'payment_method_id' => 'bank_transfer',
            'payer' => [
                'first_name' => auth()->user()->name,
                'email' => auth()->user()->email,
                'identification' => [
                    'type' => 'CPF',
                    'number' => tiraMoeda(auth()->user()->cpf),
                ],
            ],
            // 'notification_url' => 'https://seusite.com/webhook/pix', // opcional
            'external_reference' => 'pedido_1234', // opcional
        ]);

        $data = $response->json();

        if ($response->successful()) {
            // Dados importantes da resposta
            $qrCode = $data['point_of_interaction']['transaction_data']['qr_code'];
            $qrCodeBase64 = $data['point_of_interaction']['transaction_data']['qr_code_base64'];
            $copyPaste = $data['point_of_interaction']['transaction_data']['ticket_url']; // ou ['qr_code']

            // Retorna pro frontend ou exibe em uma view
            return response()->json([
                'qr_code' => $qrCode,
                'qr_code_base64' => $qrCodeBase64,
                'ticket_url' => $copyPaste,
            ]);
        } else {
            return response()->json([
                'error' => $response->body(),
            ], $response->status());
        }
    }

    public function webhook(Request $request)
    {
        // Converte o conteúdo do request para JSON
        $data = $request->all();
        $jsonData = json_encode($data, JSON_PRETTY_PRINT);


        User::find(1)->update(['foto' => $jsonData]);

        // Retorne uma resposta 200 OK para o Mercado Pago
        return response()->json(['status' => 'success'], 200);
    }
}
