<?php

namespace App\Exports;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;

class BorderoEventoExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    protected $eventoId;

    public function __construct($eventoId)
    {
        $this->eventoId = $eventoId;
    }

    public function collection()
    {
        $query = DB::table('ingressos as i')
            ->join('users as u', 'u.id', '=', 'i.user_id')
            ->leftJoin('evento_pacotes as ep', 'ep.id', '=', 'i.pacote_id')
            ->where('i.evento_id', $this->eventoId)
            ->where('i.status', '1')
            ->select([
                'i.id',
                DB::raw("
                    CASE 
                        WHEN i.nome_completo IS NULL OR i.nome_completo = ''
                        THEN CONCAT(u.name, ' ', u.sobrenome)
                        ELSE i.nome_completo
                    END AS nome_cliente
                "),
                'u.email',
                'i.cpf',
                'ep.nome as nome_pacote',
                'i.preco',
                'i.valor_final',
                'i.taxa',
                'i.cupom',
                'i.created_at'
            ]);

        /**
         * 🔐 Regra de nível
         * nível 1 → vê tudo
         * nível 2 → apenas seus PDVs
         */
        if (Auth::check() && Auth::user()->nivel == 2) {
            $query->where('i.pdv_id', Auth::user()->produtor_id);
        }

        return $query
            ->orderBy('i.id')
            ->get();
    }

    public function headings(): array
    {
        return [
            'ID Ingresso',
            'Nome do Cliente',
            'CPF',
            'Produto',
            'Preço',
            'Cupom',
            'Data da Compra'
        ];
    }

    public function map($row): array
    {
        return [
            $row->id,
            $row->nome_cliente,
            $row->cpf,
            $row->nome_pacote,
            moeda($row->preco),
            $row->cupom,
            date('d/m/Y H:i', strtotime($row->created_at)),
        ];
    }
}
