<?php

namespace App\Exports;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class BorderoEventLimitadooExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    protected $eventoId;
    protected $limite = 2000000;

    public function __construct($eventoId)
    {
        $this->eventoId = $eventoId;
    }

    public function collection()
    {
        // 1️⃣ Dados agrupados
        $linhas = DB::table('ingressos as i')
            ->leftJoin('evento_pacotes as ep', 'ep.id', '=', 'i.pacote_id')
            ->where('i.evento_id', $this->eventoId)
            ->where('i.status', '1')
            ->where('i.check_in_situacao', '0')
            ->selectRaw('
                ep.nome as produto,
                i.preco as valor,
                COUNT(i.id) as qtd,
                SUM(i.preco) as total
            ')
            ->groupBy('ep.nome', 'i.preco')
            ->orderBy('ep.nome')
            ->orderBy('i.preco')
            ->get();

        $totalReal = $linhas->sum('total');

        if ($totalReal <= 0) {
            return collect();
        }

        // 2️⃣ Fator de redução proporcional
        $fator = $this->limite / $totalReal;

        $resultado = collect();
        $qtdTotal = 0;
        $totalCalculado = 0;

        foreach ($linhas as $linha) {
            $qtdAjustada = max(1, floor($linha->qtd * $fator));
            $totalAjustado = $qtdAjustada * $linha->valor;

            $resultado->push([
                'produto'   => $linha->produto,
                'qtd'       => $qtdAjustada,
                'valor'     => moeda($linha->valor),
                'total'     => moeda($totalAjustado),
                'total_num' => $totalAjustado, // 👈 valor real para ajuste
            ]);

            $qtdTotal += $qtdAjustada;
            $totalCalculado += $totalAjustado;
        }

        // 3️⃣ Ajuste fino para fechar EXATOS 20.000,00
        $diferenca = $this->limite - $totalCalculado;

        if ($diferenca != 0 && $resultado->count() > 0) {
            $ultima = $resultado->pop();

            $novoTotal = $ultima['total_num'] + $diferenca;

            $ultima['total'] = moeda($novoTotal);
            $ultima['total_num'] = $novoTotal;

            $resultado->push($ultima);
        }

        // 4️⃣ Sub-total
        $resultado->push([
            'produto' => 'Sub-total (R$):',
            'qtd'     => $qtdTotal,
            'valor'   => '',
            'total'   => moeda($this->limite),
        ]);

        // 5️⃣ Ticket médio
        $ticketMedio = $qtdTotal > 0 ? $this->limite / $qtdTotal : 0;

        $resultado->push([
            'produto' => 'Ticket Médio (R$):',
            'qtd'     => '',
            'valor'   => '',
            'total'   => moeda($ticketMedio),
        ]);

        return $resultado->map(function ($linha) {
            unset($linha['total_num']); // remove coluna técnica
            return $linha;
        });
    }

    public function headings(): array
    {
        return [
            'Produto',
            'Qtd.',
            'Valor (R$)',
            'Total (R$)',
        ];
    }
}
